/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.karaf;

import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.ArgumentCompleter;
import org.apache.karaf.shell.console.completer.StringsCompleter;
import org.apache.karaf.shell.console.jline.CommandSessionHolder;
import org.switchyard.admin.Application;
import org.switchyard.admin.Binding;
import org.switchyard.admin.Reference;
import org.switchyard.admin.Service;
import org.switchyard.admin.SwitchYard;

public class BindingNameCompleter
implements Completer {
    private SwitchYard _switchYard;

    public int complete(String buffer, int cursor, List<String> candidates) {
        StringsCompleter delegate = new StringsCompleter();
        CommandSession session = CommandSessionHolder.getSession();
        if (session == null) {
            return delegate.complete(buffer, cursor, candidates);
        }
        ArgumentCompleter.ArgumentList argList = (ArgumentCompleter.ArgumentList)session.get("ARGUMENTS_LIST");
        if (argList == null || argList.getArguments() == null || argList.getArguments().length == 4) {
            return delegate.complete(buffer, cursor, candidates);
        }
        List<String> arguments = Arrays.asList(argList.getArguments());
        Application application = this._switchYard.getApplication(QName.valueOf(arguments.get(2)));
        if (application == null) {
            return delegate.complete(buffer, cursor, candidates);
        }
        QName serviceOrReferenceName = QName.valueOf(arguments.get(3));
        Service service = application.getService(serviceOrReferenceName);
        if (service == null) {
            Reference reference = application.getReference(serviceOrReferenceName);
            if (reference == null) {
                return delegate.complete(buffer, cursor, candidates);
            }
            for (Binding binding : reference.getGateways()) {
                if (binding.getName() == null) continue;
                delegate.getStrings().add(binding.getName());
            }
        } else {
            for (Binding binding : service.getGateways()) {
                if (binding.getName() == null) continue;
                delegate.getStrings().add(binding.getName());
            }
        }
        return delegate.complete(buffer, cursor, candidates);
    }

    public void setSwitchYard(SwitchYard switchYard) {
        this._switchYard = switchYard;
    }
}

