/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.ode.bpel.o.OActivity;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.bpel.o.OSequence;
import org.apache.ode.bpel.runtime.ACTIVITY;
import org.apache.ode.bpel.runtime.ActivityInfo;
import org.apache.ode.bpel.runtime.BpelJacobRunnable;
import org.apache.ode.bpel.runtime.CompensationHandler;
import org.apache.ode.bpel.runtime.LinkFrame;
import org.apache.ode.bpel.runtime.ScopeFrame;
import org.apache.ode.bpel.runtime.channels.FaultData;
import org.apache.ode.bpel.runtime.channels.ParentScopeChannel;
import org.apache.ode.bpel.runtime.channels.ParentScopeChannelListener;
import org.apache.ode.bpel.runtime.channels.TerminationChannel;
import org.apache.ode.bpel.runtime.channels.TerminationChannelListener;
import org.apache.ode.jacob.SynchChannel;
import org.w3c.dom.Element;

class SEQUENCE
extends ACTIVITY {
    private static final long serialVersionUID = 1L;
    private final List<OActivity> _remaining;
    private final Set<CompensationHandler> _compensations;

    SEQUENCE(ActivityInfo self, ScopeFrame scopeFrame, LinkFrame linkFrame) {
        this(self, scopeFrame, linkFrame, ((OSequence)self.o).sequence, CompensationHandler.emptySet());
    }

    SEQUENCE(ActivityInfo self, ScopeFrame scopeFrame, LinkFrame linkFrame, List<OActivity> remaining, Set<CompensationHandler> compensations) {
        super(self, scopeFrame, linkFrame);
        this._remaining = Collections.unmodifiableList(remaining);
        this._compensations = Collections.unmodifiableSet(compensations);
    }

    @Override
    public void run() {
        ActivityInfo child = new ActivityInfo(this.genMonotonic(), this._remaining.get(0), this.newChannel(TerminationChannel.class), this.newChannel(ParentScopeChannel.class));
        SEQUENCE.instance(this.createChild(child, this._scopeFrame, this._linkFrame));
        SEQUENCE.instance(new ACTIVE(child));
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer("SEQUENCE(self=");
        buf.append(this._self);
        buf.append(", linkframe=");
        buf.append(this._linkFrame);
        buf.append(", remaining=");
        buf.append(this._remaining);
        buf.append(')');
        return buf.toString();
    }

    private class ACTIVE
    extends BpelJacobRunnable {
        private static final long serialVersionUID = -2663862698981385732L;
        private ActivityInfo _child;
        private boolean _terminateRequested = false;

        ACTIVE(ActivityInfo child) {
            this._child = child;
        }

        @Override
        public void run() {
            ACTIVE.object(false, new TerminationChannelListener(SEQUENCE.this._self.self){
                private static final long serialVersionUID = -2680515407515637639L;

                @Override
                public void terminate() {
                    2.replication(((ACTIVE)ACTIVE.this)._child.self).terminate();
                    ArrayList remaining = new ArrayList(SEQUENCE.this._remaining);
                    remaining.remove(0);
                    ACTIVE.this.deadPathRemaining(remaining);
                    ACTIVE.this._terminateRequested = true;
                    2.instance(ACTIVE.this);
                }
            }.or(new ParentScopeChannelListener(this._child.parent){
                private static final long serialVersionUID = 7195562310281985971L;

                @Override
                public void compensate(OScope scope, SynchChannel ret) {
                    SEQUENCE.this._self.parent.compensate(scope, ret);
                    1.instance(ACTIVE.this);
                }

                @Override
                public void completed(FaultData faultData, Set<CompensationHandler> compensations) {
                    TreeSet<CompensationHandler> comps = new TreeSet<CompensationHandler>(SEQUENCE.this._compensations);
                    comps.addAll(compensations);
                    if (faultData != null || ACTIVE.this._terminateRequested || SEQUENCE.this._remaining.size() <= 1) {
                        ACTIVE.this.deadPathRemaining(SEQUENCE.this._remaining);
                        SEQUENCE.this._self.parent.completed(faultData, comps);
                    } else {
                        ArrayList<OActivity> remaining = new ArrayList<OActivity>(SEQUENCE.this._remaining);
                        remaining.remove(0);
                        1.instance(new SEQUENCE(SEQUENCE.this._self, SEQUENCE.this._scopeFrame, SEQUENCE.this._linkFrame, remaining, comps));
                    }
                }

                @Override
                public void cancelled() {
                    this.completed(null, CompensationHandler.emptySet());
                }

                @Override
                public void failure(String reason, Element data) {
                    this.completed(null, CompensationHandler.emptySet());
                }
            }));
        }

        private void deadPathRemaining(List<OActivity> remaining) {
            Iterator<OActivity> i = remaining.iterator();
            while (i.hasNext()) {
                SEQUENCE.this.dpe(i.next());
            }
        }
    }
}

