/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.management;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Pattern;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.management.boot.KarafMBeanServerBuilder;
import org.apache.karaf.management.tools.ACLConfigurationParser;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KarafMBeanServerGuard
implements InvocationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(KarafMBeanServerGuard.class);
    private static final String JMX_ACL_PID_PREFIX = "jmx.acl";
    private static final String JMX_ACL_WHITELIST = "jmx.acl.whitelist";
    private static final String ROLE_WILDCARD = "*";
    private static final String JMX_OBJECTNAME_PROPERTY_WILDCARD = "_";
    private ConfigurationAdmin configAdmin;

    public ConfigurationAdmin getConfigAdmin() {
        return this.configAdmin;
    }

    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    public void init() {
        KarafMBeanServerBuilder.setGuard((InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getParameterTypes().length == 0) {
            return null;
        }
        if (!ObjectName.class.isAssignableFrom(method.getParameterTypes()[0])) {
            return null;
        }
        ObjectName objectName = (ObjectName)args[0];
        if ("getAttribute".equals(method.getName())) {
            this.handleGetAttribute((MBeanServer)proxy, objectName, (String)args[1]);
        } else if ("getAttributes".equals(method.getName())) {
            this.handleGetAttributes((MBeanServer)proxy, objectName, (String[])args[1]);
        } else if ("setAttribute".equals(method.getName())) {
            this.handleSetAttribute((MBeanServer)proxy, objectName, (Attribute)args[1]);
        } else if ("setAttributes".equals(method.getName())) {
            this.handleSetAttributes((MBeanServer)proxy, objectName, (AttributeList)args[1]);
        } else if ("invoke".equals(method.getName())) {
            this.handleInvoke(objectName, (String)args[1], (Object[])args[2], (String[])args[3]);
        }
        return null;
    }

    public boolean canInvoke(MBeanServer mbeanServer, ObjectName objectName) throws JMException, IOException {
        MBeanInfo info = mbeanServer.getMBeanInfo(objectName);
        for (MBeanOperationInfo mBeanOperationInfo : info.getOperations()) {
            ArrayList<String> sig = new ArrayList<String>();
            for (MBeanParameterInfo param : mBeanOperationInfo.getSignature()) {
                sig.add(param.getType());
            }
            if (!this.canInvoke(objectName, mBeanOperationInfo.getName(), sig.toArray(new String[0]))) continue;
            return true;
        }
        for (MBeanFeatureInfo mBeanFeatureInfo : info.getAttributes()) {
            if (((MBeanAttributeInfo)mBeanFeatureInfo).isReadable() && this.canInvoke(objectName, ((MBeanAttributeInfo)mBeanFeatureInfo).isIs() ? "is" : "get" + mBeanFeatureInfo.getName(), new String[0])) {
                return true;
            }
            if (!((MBeanAttributeInfo)mBeanFeatureInfo).isWritable() || !this.canInvoke(objectName, "set" + mBeanFeatureInfo.getName(), new String[]{((MBeanAttributeInfo)mBeanFeatureInfo).getType()})) continue;
            return true;
        }
        return false;
    }

    public boolean canInvoke(MBeanServer mbeanServer, ObjectName objectName, String methodName) throws JMException, IOException {
        methodName = methodName.trim();
        MBeanInfo info = mbeanServer.getMBeanInfo(objectName);
        for (MBeanOperationInfo mBeanOperationInfo : info.getOperations()) {
            if (!methodName.equals(mBeanOperationInfo.getName())) continue;
            ArrayList<String> sig = new ArrayList<String>();
            for (MBeanParameterInfo param : mBeanOperationInfo.getSignature()) {
                sig.add(param.getType());
            }
            if (!this.canInvoke(objectName, mBeanOperationInfo.getName(), sig.toArray(new String[0]))) continue;
            return true;
        }
        for (MBeanFeatureInfo mBeanFeatureInfo : info.getAttributes()) {
            String attrName = mBeanFeatureInfo.getName();
            if (methodName.equals("is" + attrName) || methodName.equals("get" + attrName)) {
                return this.canInvoke(objectName, methodName, new String[0]);
            }
            if (!methodName.equals("set" + attrName)) continue;
            return this.canInvoke(objectName, methodName, new String[]{((MBeanAttributeInfo)mBeanFeatureInfo).getType()});
        }
        return false;
    }

    public boolean canInvoke(MBeanServer mbeanServer, ObjectName objectName, String methodName, String[] signature) throws IOException {
        return this.canInvoke(objectName, methodName, signature);
    }

    private boolean canInvoke(ObjectName objectName, String methodName, String[] signature) throws IOException {
        if (this.canBypassRBAC(objectName)) {
            return true;
        }
        for (String role : this.getRequiredRoles(objectName, methodName, signature)) {
            if (!KarafMBeanServerGuard.currentUserHasRole(role)) continue;
            return true;
        }
        return false;
    }

    private void handleGetAttribute(MBeanServer proxy, ObjectName objectName, String attributeName) throws JMException, IOException {
        MBeanInfo info = proxy.getMBeanInfo(objectName);
        String prefix = null;
        for (MBeanAttributeInfo attr : info.getAttributes()) {
            if (!attr.getName().equals(attributeName)) continue;
            prefix = attr.isIs() ? "is" : "get";
        }
        if (prefix == null) {
            LOG.debug("Attribute " + attributeName + " can not be found for MBean " + objectName.toString());
        }
        this.handleInvoke(objectName, prefix + attributeName, new Object[0], new String[0]);
    }

    private void handleGetAttributes(MBeanServer proxy, ObjectName objectName, String[] attributeNames) throws JMException, IOException {
        for (String attr : attributeNames) {
            this.handleGetAttribute(proxy, objectName, attr);
        }
    }

    private void handleSetAttribute(MBeanServer proxy, ObjectName objectName, Attribute attribute) throws JMException, IOException {
        String dataType = null;
        MBeanInfo info = proxy.getMBeanInfo(objectName);
        for (MBeanAttributeInfo attr : info.getAttributes()) {
            if (!attr.getName().equals(attribute.getName())) continue;
            dataType = attr.getType();
            break;
        }
        if (dataType == null) {
            throw new IllegalStateException("Attribute data type can not be found");
        }
        this.handleInvoke(objectName, "set" + attribute.getName(), new Object[]{attribute.getValue()}, new String[]{dataType});
    }

    private void handleSetAttributes(MBeanServer proxy, ObjectName objectName, AttributeList attributes) throws JMException, IOException {
        for (Attribute attr : attributes.asList()) {
            this.handleSetAttribute(proxy, objectName, attr);
        }
    }

    private boolean canBypassRBAC(ObjectName objectName) {
        ArrayList<String> allBypassObjectName = new ArrayList<String>();
        try {
            Configuration[] configs = this.configAdmin.listConfigurations("(service.pid=jmx.acl.whitelist)");
            if (configs != null) {
                for (Configuration config : configs) {
                    Enumeration keys = config.getProperties().keys();
                    while (keys.hasMoreElements()) {
                        String element = (String)keys.nextElement();
                        allBypassObjectName.add(element);
                    }
                }
            }
        }
        catch (InvalidSyntaxException ise) {
            throw new RuntimeException(ise);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (String pid : this.iterateDownPids(this.getNameSegments(objectName))) {
            if (pid.equals(JMX_ACL_PID_PREFIX) || !allBypassObjectName.contains(pid.substring("jmx.acl.".length()))) continue;
            return true;
        }
        return false;
    }

    void handleInvoke(ObjectName objectName, String operationName, Object[] params, String[] signature) throws IOException {
        if (this.canBypassRBAC(objectName)) {
            return;
        }
        for (String role : this.getRequiredRoles(objectName, operationName, params, signature)) {
            if (!KarafMBeanServerGuard.currentUserHasRole(role)) continue;
            return;
        }
        throw new SecurityException("Insufficient roles/credentials for operation");
    }

    List<String> getRequiredRoles(ObjectName objectName, String methodName, String[] signature) throws IOException {
        return this.getRequiredRoles(objectName, methodName, null, signature);
    }

    List<String> getRequiredRoles(ObjectName objectName, String methodName, Object[] params, String[] signature) throws IOException {
        ArrayList<String> allPids = new ArrayList<String>();
        try {
            for (Configuration config : this.configAdmin.listConfigurations("(service.pid=jmx.acl*)")) {
                allPids.add(config.getPid());
            }
        }
        catch (InvalidSyntaxException ise) {
            throw new RuntimeException(ise);
        }
        for (String pid : this.iterateDownPids(this.getNameSegments(objectName))) {
            Configuration config;
            String generalPid = this.getGeneralPid(allPids, pid);
            if (generalPid.length() <= 0) continue;
            config = this.configAdmin.getConfiguration(generalPid);
            ArrayList<String> roles = new ArrayList<String>();
            ACLConfigurationParser.Specificity s = ACLConfigurationParser.getRolesForInvocation(methodName, params, signature, config.getProperties(), roles);
            if (s == ACLConfigurationParser.Specificity.NO_MATCH) continue;
            return roles;
        }
        return Collections.emptyList();
    }

    private String getGeneralPid(List<String> allPids, String pid) {
        String ret = "";
        String[] pidStrArray = pid.split(Pattern.quote("."));
        for (String id : allPids) {
            String[] idStrArray = id.split(Pattern.quote("."));
            if (idStrArray.length != pidStrArray.length) continue;
            boolean match = true;
            for (int i = 0; i < idStrArray.length; ++i) {
                if (idStrArray[i].equals(JMX_OBJECTNAME_PROPERTY_WILDCARD) || idStrArray[i].equals(pidStrArray[i])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            ret = id;
            return ret;
        }
        return ret;
    }

    private List<String> getNameSegments(ObjectName objectName) {
        ArrayList<String> segments = new ArrayList<String>();
        segments.add(objectName.getDomain());
        for (String s : objectName.getKeyPropertyListString().split("[,]")) {
            int index = s.indexOf(61);
            if (index < 0) continue;
            String key = objectName.getKeyProperty(s.substring(0, index));
            if (s.substring(0, index).equals("type")) {
                segments.add(1, key);
                continue;
            }
            segments.add(key);
        }
        return segments;
    }

    private List<String> iterateDownPids(List<String> segments) {
        ArrayList<String> res = new ArrayList<String>();
        for (int i = segments.size(); i > 0; --i) {
            StringBuilder sb = new StringBuilder();
            sb.append(JMX_ACL_PID_PREFIX);
            for (int j = 0; j < i; ++j) {
                sb.append('.');
                sb.append(segments.get(j));
            }
            res.add(sb.toString());
        }
        res.add(JMX_ACL_PID_PREFIX);
        return res;
    }

    static boolean currentUserHasRole(String requestedRole) {
        String role;
        String clazz;
        if (ROLE_WILDCARD.equals(requestedRole)) {
            return true;
        }
        int index = requestedRole.indexOf(58);
        if (index > 0) {
            clazz = requestedRole.substring(0, index);
            role = requestedRole.substring(index + 1);
        } else {
            clazz = RolePrincipal.class.getName();
            role = requestedRole;
        }
        AccessControlContext acc = AccessController.getContext();
        if (acc == null) {
            return false;
        }
        Subject subject = Subject.getSubject(acc);
        if (subject == null) {
            return false;
        }
        for (Principal p : subject.getPrincipals()) {
            if (!clazz.equals(p.getClass().getName()) || !role.equals(p.getName())) continue;
            return true;
        }
        return false;
    }
}

