/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.weaving.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.persistence.spi.ClassTransformer;
import org.apache.aries.jpa.container.impl.NLS;
import org.apache.aries.jpa.container.weaving.impl.TransformerRegistry;
import org.apache.aries.jpa.container.weaving.impl.WrappingTransformer;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.weaving.WeavingException;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.hooks.weaving.WovenClass;
import org.osgi.framework.wiring.BundleWiring;

public class JPAWeavingHook
implements WeavingHook,
TransformerRegistry {
    private final ConcurrentMap<Bundle, LinkedHashSet<WrappingTransformer>> registeredTransformers = new ConcurrentHashMap<Bundle, LinkedHashSet<WrappingTransformer>>();

    JPAWeavingHook() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void weave(WovenClass wovenClass) {
        BundleWiring wiring = wovenClass.getBundleWiring();
        Collection transformers = (Collection)this.registeredTransformers.get(wiring.getBundle());
        if (transformers != null) {
            ArrayList transformersToTry;
            Collection collection = transformers;
            synchronized (collection) {
                transformersToTry = new ArrayList(transformers);
            }
            for (WrappingTransformer transformer : transformersToTry) {
                try {
                    byte[] result = transformer.transform(wiring.getClassLoader(), wovenClass.getClassName(), wovenClass.getDefinedClass(), wovenClass.getProtectionDomain(), wovenClass.getBytes());
                    if (result == null) continue;
                    wovenClass.setBytes(result);
                    wovenClass.getDynamicImports().addAll(transformer.getPackagesToAdd());
                    break;
                }
                catch (Throwable t) {
                    if (t instanceof ThreadDeath) {
                        throw (ThreadDeath)t;
                    }
                    if (t instanceof OutOfMemoryError) {
                        throw (OutOfMemoryError)t;
                    }
                    Bundle b = wovenClass.getBundleWiring().getBundle();
                    throw new WeavingException(NLS.MESSAGES.getMessage("jpa.weaving.failure", new Object[]{wovenClass.getClassName(), b.getSymbolicName(), b.getVersion(), transformer}), t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTransformer(Bundle pBundle, ClassTransformer transformer, ServiceReference<?> provider) {
        LinkedHashSet<WrappingTransformer> set = new LinkedHashSet<WrappingTransformer>();
        WrappingTransformer wt = new WrappingTransformer(transformer, provider);
        set.add(wt);
        LinkedHashSet<WrappingTransformer> existingSet = this.registeredTransformers.putIfAbsent(pBundle, set);
        if (existingSet != null) {
            LinkedHashSet<WrappingTransformer> linkedHashSet = existingSet;
            synchronized (linkedHashSet) {
                existingSet.add(wt);
            }
        }
    }

    @Override
    public void removeTransformer(Bundle pBundle, ClassTransformer transformer) {
        LinkedHashSet set = (LinkedHashSet)this.registeredTransformers.get(pBundle);
        if (set == null || !this.safeRemove(set, transformer)) {
            throw new IllegalStateException(NLS.MESSAGES.getMessage("jpa.weaving.transformer.not.registered", new Object[]{transformer}));
        }
        if (set.isEmpty()) {
            this.registeredTransformers.remove(pBundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean safeRemove(Collection<WrappingTransformer> set, ClassTransformer t) {
        Collection<WrappingTransformer> collection = set;
        synchronized (collection) {
            return set.remove(new WrappingTransformer(t));
        }
    }
}

