/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jndi.url;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.aries.jndi.services.ServiceHelper;
import org.apache.aries.jndi.url.AbstractServiceRegistryContext;
import org.apache.aries.jndi.url.OsgiName;
import org.apache.aries.jndi.url.ServiceRegistryListContext;
import org.apache.aries.util.nls.MessageUtil;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.BundleContext;

public class ServiceRegistryContext
extends AbstractServiceRegistryContext
implements Context {
    private OsgiName parentName;
    private static final MessageUtil MESSAGES = MessageUtil.createMessageUtil(ServiceRegistryContext.class, (String)"org.apache.aries.jndi.nls.jndiUrlMessages");

    public ServiceRegistryContext(BundleContext callerContext, Hashtable<?, ?> environment) {
        super(callerContext, environment);
    }

    public ServiceRegistryContext(BundleContext callerContext, OsgiName validName, Map<String, Object> env) {
        super(callerContext, env);
        this.parentName = validName;
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return new ServiceRegistryListContext(this.callerContext, this.env, this.convert(name)).list("");
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        return this.list(this.parse(name));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return new ServiceRegistryListContext(this.callerContext, this.env, this.convert(name)).listBindings("");
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        return this.listBindings(this.parse(name));
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        Object result;
        OsgiName validName = this.convert(name);
        String pathFragment = validName.getSchemePath();
        String schemeName = validName.getScheme();
        if (validName.hasInterface()) {
            if ("framework".equals(pathFragment) && "bundleContext".equals(validName.getServiceName())) {
                AdminPermission adminPermission = new AdminPermission(this.callerContext.getBundle(), "context");
                try {
                    AccessController.checkPermission((Permission)adminPermission);
                    return this.callerContext;
                }
                catch (AccessControlException accessControlException) {
                    NameNotFoundException namingException = new NameNotFoundException(MESSAGES.getMessage("caller.not.priviledged", new Object[0]));
                    namingException.setRootCause(accessControlException);
                    throw namingException;
                }
            }
            result = "service".equals(pathFragment) && "osgi".equals(schemeName) || "services".equals(pathFragment) && "aries".equals(schemeName) ? ServiceHelper.getService(this.callerContext, validName, null, true, this.env, "osgi".equals(schemeName)) : ("servicelist".equals(pathFragment) ? new ServiceRegistryListContext(this.callerContext, this.env, validName) : null);
        } else {
            result = new ServiceRegistryContext(this.callerContext, validName, this.env);
        }
        if (result == null) {
            throw new NameNotFoundException(name.toString());
        }
        return result;
    }

    private OsgiName convert(Name name) throws NamingException {
        if (name instanceof OsgiName) {
            return (OsgiName)name;
        }
        if (this.parentName != null) {
            return new OsgiName(this.parentName.toString() + "/" + name.toString());
        }
        return (OsgiName)this.parser.parse(name.toString());
    }

    private Name parse(String name) throws NamingException {
        if (this.parentName != null) {
            name = this.parentName.toString() + "/" + name;
        }
        return this.parser.parse(name);
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.lookup(this.parse(name));
    }
}

