/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelException;
import org.apache.camel.component.netty4.NettyConsumer;
import org.apache.camel.component.netty4.NettyServerBootstrapConfiguration;
import org.apache.camel.component.netty4.NettyServerBootstrapFactory;
import org.apache.camel.component.netty4.NettyWorkerPoolBuilder;
import org.apache.camel.support.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientModeTCPNettyServerBootstrapFactory
extends ServiceSupport
implements NettyServerBootstrapFactory {
    protected static final Logger LOG = LoggerFactory.getLogger(ClientModeTCPNettyServerBootstrapFactory.class);
    private CamelContext camelContext;
    private ThreadFactory threadFactory;
    private NettyServerBootstrapConfiguration configuration;
    private ChannelInitializer<Channel> pipelineFactory;
    private Bootstrap clientBootstrap;
    private Channel channel;
    private EventLoopGroup workerGroup;

    @Override
    public void init(CamelContext camelContext, NettyServerBootstrapConfiguration configuration, ChannelInitializer<Channel> pipelineFactory) {
        this.camelContext = camelContext;
        this.configuration = configuration;
        this.pipelineFactory = pipelineFactory;
    }

    @Override
    public void init(ThreadFactory threadFactory, NettyServerBootstrapConfiguration configuration, ChannelInitializer<Channel> pipelineFactory) {
        this.threadFactory = threadFactory;
        this.configuration = configuration;
        this.pipelineFactory = pipelineFactory;
    }

    @Override
    public void addChannel(Channel channel) {
    }

    @Override
    public void removeChannel(Channel channel) {
    }

    @Override
    public void addConsumer(NettyConsumer consumer) {
    }

    @Override
    public void removeConsumer(NettyConsumer consumer) {
    }

    protected void doStart() throws Exception {
        if (this.camelContext == null && this.threadFactory == null) {
            throw new IllegalArgumentException("Either CamelContext or ThreadFactory must be set on " + this);
        }
        this.startServerBootstrap();
    }

    protected void doStop() throws Exception {
        this.stopServerBootstrap();
    }

    protected void doResume() throws Exception {
        LOG.debug("ClientModeServerBootstrap connect to {}:{}", (Object)this.configuration.getHost(), (Object)this.configuration.getPort());
        ChannelFuture connectFuture = this.clientBootstrap.connect((SocketAddress)new InetSocketAddress(this.configuration.getHost(), this.configuration.getPort()));
        this.channel = this.openChannel(connectFuture);
    }

    protected void doSuspend() throws Exception {
        if (this.channel != null) {
            LOG.debug("ClientModeServerBootstrap unbinding from {}:{}", (Object)this.configuration.getHost(), (Object)this.configuration.getPort());
            this.channel.close().sync();
            this.channel = null;
        }
    }

    protected void startServerBootstrap() throws Exception {
        EventLoopGroup wg = this.configuration.getWorkerGroup();
        if (wg == null) {
            wg = this.workerGroup = new NettyWorkerPoolBuilder().withWorkerCount(this.configuration.getWorkerCount()).withName("NettyServerTCPWorker").build();
        }
        this.clientBootstrap = new Bootstrap();
        this.clientBootstrap.channel(NioSocketChannel.class);
        this.clientBootstrap.group(wg);
        this.clientBootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)this.configuration.isKeepAlive());
        this.clientBootstrap.option(ChannelOption.TCP_NODELAY, (Object)this.configuration.isTcpNoDelay());
        this.clientBootstrap.option(ChannelOption.SO_REUSEADDR, (Object)this.configuration.isReuseAddress());
        this.clientBootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.configuration.getConnectTimeout());
        LOG.debug("Created ClientBootstrap {}", (Object)this.clientBootstrap);
        this.clientBootstrap.handler(this.pipelineFactory);
        ChannelFuture channelFuture = this.clientBootstrap.connect((SocketAddress)new InetSocketAddress(this.configuration.getHost(), this.configuration.getPort()));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created new TCP client bootstrap connecting to {}:{} with options: {}", new Object[]{this.configuration.getHost(), this.configuration.getPort(), this.clientBootstrap});
        }
        LOG.info("ClientModeServerBootstrap binding to {}:{}", (Object)this.configuration.getHost(), (Object)this.configuration.getPort());
        this.channel = this.openChannel(channelFuture);
    }

    protected void stopServerBootstrap() {
        LOG.info("ClientModeServerBootstrap unbinding from {}:{}", (Object)this.configuration.getHost(), (Object)this.configuration.getPort());
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
            this.workerGroup = null;
        }
    }

    protected void doReconnectIfNeeded() throws Exception {
        if (this.channel == null || !this.channel.isActive()) {
            LOG.debug("ClientModeServerBootstrap re-connect to {}:{}", (Object)this.configuration.getHost(), (Object)this.configuration.getPort());
            ChannelFuture connectFuture = this.clientBootstrap.connect((SocketAddress)new InetSocketAddress(this.configuration.getHost(), this.configuration.getPort()));
            this.channel = this.openChannel(connectFuture);
        }
    }

    protected Channel openChannel(final ChannelFuture channelFuture) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Waiting for operation to complete {} for {} millis", (Object)channelFuture, (Object)this.configuration.getConnectTimeout());
        }
        final CountDownLatch channelLatch = new CountDownLatch(1);
        channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture cf) throws Exception {
                channelLatch.countDown();
            }
        });
        try {
            channelLatch.await(this.configuration.getConnectTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new CamelException("Interrupted while waiting for connection to " + this.configuration.getAddress());
        }
        if (!channelFuture.isDone() || !channelFuture.isSuccess()) {
            if (this.configuration.isReconnect()) {
                this.scheduleReconnect(channelFuture);
                return null;
            }
            ConnectException cause = new ConnectException("Cannot connect to " + this.configuration.getAddress());
            if (channelFuture.cause() != null) {
                cause.initCause(channelFuture.cause());
            }
            throw cause;
        }
        Channel answer = channelFuture.channel();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating connector to address: {}", (Object)this.configuration.getAddress());
        }
        if (this.configuration.isReconnect()) {
            answer.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    ClientModeTCPNettyServerBootstrapFactory.this.scheduleReconnect(channelFuture);
                }
            });
        }
        return answer;
    }

    private void scheduleReconnect(ChannelFuture channelFuture) {
        EventLoop loop = channelFuture.channel().eventLoop();
        loop.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    LOG.trace("Re-connecting to {} if needed", (Object)ClientModeTCPNettyServerBootstrapFactory.this.configuration.getAddress());
                    ClientModeTCPNettyServerBootstrapFactory.this.doReconnectIfNeeded();
                }
                catch (Exception e) {
                    LOG.warn("Error during re-connect to " + ClientModeTCPNettyServerBootstrapFactory.this.configuration.getAddress() + ". Will attempt again in " + ClientModeTCPNettyServerBootstrapFactory.this.configuration.getReconnectInterval() + " millis. This exception is ignored.", (Throwable)e);
                }
            }
        }, (long)this.configuration.getReconnectInterval(), TimeUnit.MILLISECONDS);
    }
}

