/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.util.concurrent.ThreadFactory;
import org.apache.camel.component.netty4.NettyHelper;
import org.apache.camel.util.concurrent.CamelThreadFactory;

public final class NettyWorkerPoolBuilder {
    private String name = "NettyWorker";
    private String pattern;
    private int workerCount;
    private volatile EventLoopGroup workerPool;

    public void setName(String name) {
        this.name = name;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setWorkerCount(int workerCount) {
        this.workerCount = workerCount;
    }

    public NettyWorkerPoolBuilder withName(String name) {
        this.setName(name);
        return this;
    }

    public NettyWorkerPoolBuilder withPattern(String pattern) {
        this.setPattern(pattern);
        return this;
    }

    public NettyWorkerPoolBuilder withWorkerCount(int workerCount) {
        this.setWorkerCount(workerCount);
        return this;
    }

    public EventLoopGroup build() {
        int count = this.workerCount > 0 ? this.workerCount : NettyHelper.DEFAULT_IO_THREADS;
        this.workerPool = new NioEventLoopGroup(count, (ThreadFactory)new CamelThreadFactory(this.pattern, this.name, false));
        return this.workerPool;
    }

    public void destroy() {
        if (this.workerPool != null) {
            this.workerPool.shutdownGracefully();
            this.workerPool = null;
        }
    }
}

