/*
 * Decompiled with CFR 0.152.
 */
package au.com.bytecode.opencsv;

import java.io.IOException;
import java.util.ArrayList;

public class CSVParser {
    private final char separator;
    private final char quotechar;
    private final char escape;
    private final boolean strictQuotes;
    private String pending;
    public static final char DEFAULT_SEPARATOR = ',';
    public static final int INITIAL_READ_SIZE = 128;
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';
    public static final char DEFAULT_ESCAPE_CHARACTER = '\\';
    public static final boolean DEFAULT_STRICT_QUOTES = false;

    public CSVParser() {
        this(',', '\"', '\\');
    }

    public CSVParser(char separator) {
        this(separator, '\"', '\\');
    }

    public CSVParser(char separator, char quotechar) {
        this(separator, quotechar, '\\');
    }

    public CSVParser(char separator, char quotechar, char escape) {
        this(separator, quotechar, escape, false);
    }

    public CSVParser(char separator, char quotechar, char escape, boolean strictQuotes) {
        this.separator = separator;
        this.quotechar = quotechar;
        this.escape = escape;
        this.strictQuotes = strictQuotes;
    }

    public boolean isPending() {
        return this.pending != null;
    }

    public String[] parseLineMulti(String nextLine) throws IOException {
        return this.parseLine(nextLine, true);
    }

    public String[] parseLine(String nextLine) throws IOException {
        return this.parseLine(nextLine, false);
    }

    private String[] parseLine(String nextLine, boolean multi) throws IOException {
        if (!multi && this.pending != null) {
            this.pending = null;
        }
        if (nextLine == null) {
            if (this.pending != null) {
                String s = this.pending;
                this.pending = null;
                return new String[]{s};
            }
            return null;
        }
        ArrayList<String> tokensOnThisLine = new ArrayList<String>();
        StringBuilder sb = new StringBuilder(128);
        boolean inQuotes = false;
        if (this.pending != null) {
            sb.append(this.pending);
            this.pending = null;
            inQuotes = true;
        }
        for (int i = 0; i < nextLine.length(); ++i) {
            char c = nextLine.charAt(i);
            if (c == this.escape) {
                if (!this.isNextCharacterEscapable(nextLine, inQuotes, i)) continue;
                sb.append(nextLine.charAt(i + 1));
                ++i;
                continue;
            }
            if (c == this.quotechar) {
                if (this.isNextCharacterEscapedQuote(nextLine, inQuotes, i)) {
                    sb.append(nextLine.charAt(i + 1));
                    ++i;
                    continue;
                }
                boolean bl = inQuotes = !inQuotes;
                if (this.strictQuotes || i <= 2 || nextLine.charAt(i - 1) == this.separator || nextLine.length() <= i + 1 || nextLine.charAt(i + 1) == this.separator) continue;
                sb.append(c);
                continue;
            }
            if (c == this.separator && !inQuotes) {
                tokensOnThisLine.add(sb.toString());
                sb = new StringBuilder(128);
                continue;
            }
            if (this.strictQuotes && !inQuotes) continue;
            sb.append(c);
        }
        if (inQuotes) {
            if (multi) {
                sb.append("\n");
                this.pending = sb.toString();
                sb = null;
            } else {
                throw new IOException("Un-terminated quoted field at end of CSV line");
            }
        }
        if (sb != null) {
            tokensOnThisLine.add(sb.toString());
        }
        return tokensOnThisLine.toArray(new String[tokensOnThisLine.size()]);
    }

    private boolean isNextCharacterEscapedQuote(String nextLine, boolean inQuotes, int i) {
        return inQuotes && nextLine.length() > i + 1 && nextLine.charAt(i + 1) == this.quotechar;
    }

    protected boolean isNextCharacterEscapable(String nextLine, boolean inQuotes, int i) {
        return inQuotes && nextLine.length() > i + 1 && (nextLine.charAt(i + 1) == this.quotechar || nextLine.charAt(i + 1) == this.escape);
    }
}

