/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap;

import com.sap.conn.idoc.IDocRepository;
import com.sap.conn.idoc.jco.JCoIDocServer;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.fusesource.camel.component.sap.IDocHandlerFactory;
import org.fusesource.camel.component.sap.SapTransactionalIDocListConsumer;
import org.fusesource.camel.component.sap.SapTransactionalIDocListServerComponent;
import org.fusesource.camel.component.sap.model.idoc.DocumentList;
import org.fusesource.camel.component.sap.util.IDocUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="sap-idoclist-server", consumerClass=SapTransactionalIDocListConsumer.class, syntax="sap-idoclist-server:server:idocType:idocTypeExtension:systemRelease:applicationRelease", consumerOnly=true, title="SAP IDoc List Server")
public class SapTransactionalIDocListServerEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(SapTransactionalIDocListServerEndpoint.class);
    @UriPath(name="server", description="Specifies the server this endpoint receives an IDoc from")
    @Metadata(required="true")
    protected String serverName;
    @UriPath(name="idocType", description="Specifies the Basic IDoc Type of an IDoc consumed by this endpoint")
    @Metadata(required="true")
    protected String idocType;
    @UriPath(name="idocTypeExtension", description="Specifies the IDoc Type Extension, if any, of an IDoc consumed by this endpoint")
    @Metadata(required="false")
    protected String idocTypeExtension;
    @UriPath(name="systemRelease", description="Specifies the associated SAP Basis Release, if any, of an IDoc consumed by this endpoint")
    @Metadata(required="false")
    protected String systemRelease;
    @UriPath(name="applicationRelease", description="Specifes the associated Application Release, if any, of an IDoc consumed by this endpoint")
    @Metadata(required="false")
    protected String applicationRelease;
    @UriParam(name="propagateExceptions", description="When true, specifies that this endpoint will propagate exceptions back to the caller in SAP instead of the exchange's exception handler", defaultValue="false")
    protected boolean propagateExceptions;
    @UriParam(name="stateful", description="When true, specifies that this endpoint will initiate an SAP stateful session", defaultValue="false")
    protected boolean stateful;

    public SapTransactionalIDocListServerEndpoint() {
    }

    public SapTransactionalIDocListServerEndpoint(String uri, SapTransactionalIDocListServerComponent component) {
        super(uri, (Component)component);
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getIdocType() {
        return this.idocType;
    }

    public void setIdocType(String idocType) {
        this.idocType = idocType;
    }

    public String getIdocTypeExtension() {
        return this.idocTypeExtension;
    }

    public void setIdocTypeExtension(String idocTypeExtension) {
        this.idocTypeExtension = idocTypeExtension;
    }

    public String getSystemRelease() {
        return this.systemRelease;
    }

    public void setSystemRelease(String systemRelease) {
        this.systemRelease = systemRelease;
    }

    public String getApplicationRelease() {
        return this.applicationRelease;
    }

    public void setApplicationRelease(String applicationRelease) {
        this.applicationRelease = applicationRelease;
    }

    public boolean isPropagateExceptions() {
        return this.propagateExceptions;
    }

    public void setPropagateExceptions(boolean propagateExceptions) {
        this.propagateExceptions = propagateExceptions;
    }

    public boolean isStateful() {
        return this.stateful;
    }

    public void setStateful(boolean stateful) {
        this.stateful = stateful;
    }

    public boolean isSingleton() {
        return true;
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("Endpoint '" + this.getEndpointUri() + "' does not support producers");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        IDocHandlerFactory handlerFactory = this.getComponent().getIDocHandlerFactory(this.serverName);
        if (handlerFactory == null) {
            throw new IllegalStateException("IDoc Handler Factory for '" + this.serverName + "' missing.");
        }
        SapTransactionalIDocListConsumer consumer = new SapTransactionalIDocListConsumer((Endpoint)this, processor);
        if (this.isStateful()) {
            consumer.setStateful(true);
        }
        handlerFactory.registerHandler(this.getIdocType(), this.getIdocTypeExtension(), this.getSystemRelease(), this.getApplicationRelease(), consumer);
        return consumer;
    }

    public DocumentList createDocumentList() throws Exception {
        try {
            return IDocUtil.createDocumentList(this.getIDocRepository(), this.getIdocType(), this.getIdocTypeExtension(), this.getSystemRelease(), this.getApplicationRelease());
        }
        catch (Exception e) {
            throw new Exception("Failed to get DocumentList from endpoint", e);
        }
    }

    public SapTransactionalIDocListServerComponent getComponent() {
        return (SapTransactionalIDocListServerComponent)super.getComponent();
    }

    protected IDocRepository getIDocRepository() throws Exception {
        return this.getServer().getIDocRepository();
    }

    protected JCoIDocServer getServer() {
        try {
            return this.getComponent().getServer(this.serverName);
        }
        catch (Exception e) {
            LOG.warn("Failed to get server object for endpoint '" + this.getEndpointUri() + "'. This exception will be ignored.", (Throwable)e);
            return null;
        }
    }
}

