/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap;

import com.sap.conn.jco.server.JCoServerContext;
import com.sap.conn.jco.server.JCoServerTIDHandler;
import java.io.File;
import java.io.FileNotFoundException;
import org.fusesource.camel.component.sap.SapSynchronousRfcServerComponent;
import org.fusesource.camel.component.sap.model.rfc.RfcFactory;
import org.fusesource.camel.component.sap.model.rfc.TIDState;
import org.fusesource.camel.component.sap.model.rfc.TIDStore;
import org.fusesource.camel.component.sap.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerTIDHandler
implements JCoServerTIDHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SapSynchronousRfcServerComponent.class);
    TIDStore availableTIDs = RfcFactory.eINSTANCE.createTIDStore();
    File tidStoreFile;

    public ServerTIDHandler(File tidStoreFile) throws Exception {
        this.tidStoreFile = tidStoreFile;
        this.loadTIDs();
    }

    public boolean checkTID(JCoServerContext serverContext, String tid) {
        TIDState state = TIDState.getByName(this.availableTIDs.getEntries().get(tid));
        if (state == null) {
            this.availableTIDs.getEntries().put(tid, TIDState.CREATED.getName());
            try {
                this.saveTIDs();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to save transaction IDs", e);
            }
            LOG.debug("Checked TID '" + tid + "': true");
            return true;
        }
        if (state == TIDState.CREATED || state == TIDState.ROLLED_BACK) {
            LOG.debug("Checked TID '" + tid + "': true");
            return true;
        }
        LOG.debug("Checked TID '" + tid + "': false");
        return false;
    }

    public void commit(JCoServerContext serverContext, String tid) {
        this.availableTIDs.getEntries().put(tid, TIDState.COMMITTED.getName());
        try {
            this.saveTIDs();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to save transaction IDs", e);
        }
        LOG.debug("Committed TID '" + tid + "'");
    }

    public void rollback(JCoServerContext serverContext, String tid) {
        this.availableTIDs.getEntries().put(tid, TIDState.ROLLED_BACK.getName());
        try {
            this.saveTIDs();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to save transaction IDs", e);
        }
        LOG.debug("Rolledback TID '" + tid + "'");
    }

    public void confirmTID(JCoServerContext serverContext, String tid) {
        this.availableTIDs.getEntries().remove(tid);
        try {
            this.saveTIDs();
        }
        catch (Exception e) {
            LOG.warn("Failed to save transaction IDs", (Throwable)e);
        }
        LOG.debug("Confirmed TID '" + tid + "'");
    }

    public void execute(JCoServerContext serverContext) {
        String tid = serverContext.getTID();
        if (tid != null) {
            this.availableTIDs.getEntries().put(tid, TIDState.EXECUTED.getName());
            try {
                this.saveTIDs();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to save transaction IDs", e);
            }
            LOG.debug("Executed TID '" + tid + "'");
        }
    }

    private void saveTIDs() throws Exception {
        Util.save(this.tidStoreFile, this.availableTIDs);
    }

    private void loadTIDs() throws Exception {
        try {
            TIDStore tidStore = (TIDStore)Util.load(this.tidStoreFile);
            this.availableTIDs.getEntries().clear();
            this.availableTIDs.getEntries().addAll(tidStore.getEntries());
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }
}

