/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.scr.action;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.scr.Component;
import org.apache.felix.scr.ScrService;
import org.apache.karaf.shell.scr.ScrUtils;
import org.apache.karaf.shell.scr.action.ScrActionSupport;

@Command(scope="scr", name="activate", description="Activates a Component for the given name")
public class ActivateAction
extends ScrActionSupport {
    @Argument(index=0, name="name", description="The name of the Component to activate ", required=true, multiValued=false)
    String name;

    @Override
    protected Object doScrAction(ScrService scrService) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Activate Action");
            this.logger.debug("  Activating the Component: " + this.name);
        }
        Component[] components = scrService.getComponents(this.name);
        for (Component component : ScrUtils.emptyIfNull(Component.class, components)) {
            component.enable();
        }
        return null;
    }
}

