/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.commands;

import java.io.PrintStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.camel.commands.AbstractCamelCommand;
import org.apache.camel.commands.CamelController;

public class ContextListCommand
extends AbstractCamelCommand {
    private static final String CONTEXT_COLUMN_LABEL = "Context";
    private static final String STATUS_COLUMN_LABEL = "Status";
    private static final String UPTIME_COLUMN_LABEL = "Uptime";
    private static final int DEFAULT_FORMAT_BUFFER_LENGTH = 24;
    private static final String DEFAULT_FIELD_PREAMBLE = " ";
    private static final String DEFAULT_FIELD_POSTAMBLE = " ";
    private static final String DEFAULT_HEADER_PREAMBLE = " ";
    private static final String DEFAULT_HEADER_POSTAMBLE = " ";
    private static final int DEFAULT_COLUMN_WIDTH_INCREMENT = 0;
    private static final int MAX_COLUMN_WIDTH = Integer.MAX_VALUE;
    private static final int MIN_COLUMN_WIDTH = 12;

    @Override
    public Object execute(CamelController camelController, PrintStream out, PrintStream err) throws Exception {
        List<Map<String, String>> camelContexts = camelController.getCamelContexts();
        Map<String, Integer> columnWidths = ContextListCommand.computeColumnWidths(camelContexts);
        String headerFormat = ContextListCommand.buildFormatString(columnWidths, true);
        String rowFormat = ContextListCommand.buildFormatString(columnWidths, false);
        if (camelContexts.size() > 0) {
            out.println(String.format(headerFormat, CONTEXT_COLUMN_LABEL, STATUS_COLUMN_LABEL, UPTIME_COLUMN_LABEL));
            out.println(String.format(headerFormat, "-------", "------", "------"));
            for (Map<String, String> row : camelContexts) {
                out.println(String.format(rowFormat, row.get("name"), row.get("state"), row.get("uptime")));
            }
        }
        return null;
    }

    private static Map<String, Integer> computeColumnWidths(Iterable<Map<String, String>> camelContexts) throws Exception {
        if (camelContexts == null) {
            throw new IllegalArgumentException("Unable to determine column widths from null Iterable<CamelContext>");
        }
        int maxNameLen = 0;
        int maxStatusLen = 0;
        int maxUptimeLen = 0;
        for (Map<String, String> row : camelContexts) {
            String name = row.get("name");
            maxNameLen = Math.max(maxNameLen, name == null ? 0 : name.length());
            String status = row.get("state");
            maxStatusLen = Math.max(maxStatusLen, status == null ? 0 : status.length());
            String uptime = row.get("uptime");
            maxUptimeLen = Math.max(maxUptimeLen, uptime == null ? 0 : uptime.length());
        }
        Hashtable<String, Integer> retval = new Hashtable<String, Integer>(3);
        retval.put(CONTEXT_COLUMN_LABEL, maxNameLen);
        retval.put(STATUS_COLUMN_LABEL, maxStatusLen);
        retval.put(UPTIME_COLUMN_LABEL, maxUptimeLen);
        return retval;
    }

    private static String buildFormatString(Map<String, Integer> columnWidths, boolean isHeader) {
        String fieldPostamble;
        String fieldPreamble;
        if (isHeader) {
            fieldPreamble = " ";
            fieldPostamble = " ";
        } else {
            fieldPreamble = " ";
            fieldPostamble = " ";
        }
        int columnWidthIncrement = 0;
        int contextLen = Math.min(columnWidths.get(CONTEXT_COLUMN_LABEL) + columnWidthIncrement, Integer.MAX_VALUE);
        int statusLen = Math.min(columnWidths.get(STATUS_COLUMN_LABEL) + columnWidthIncrement, Integer.MAX_VALUE);
        int uptimeLen = Math.min(columnWidths.get(UPTIME_COLUMN_LABEL) + columnWidthIncrement, Integer.MAX_VALUE);
        contextLen = Math.max(12, contextLen);
        statusLen = Math.max(12, statusLen);
        StringBuilder retval = new StringBuilder(24);
        retval.append(fieldPreamble).append("%-").append(contextLen).append('.').append(contextLen).append('s').append(fieldPostamble).append(' ');
        retval.append(fieldPreamble).append("%-").append(statusLen).append('.').append(statusLen).append('s').append(fieldPostamble).append(' ');
        retval.append(fieldPreamble).append("%-").append(uptimeLen).append('.').append(uptimeLen).append('s').append(fieldPostamble).append(' ');
        return retval.toString();
    }
}

