/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal.transform;

import java.util.LinkedList;
import javax.xml.namespace.QName;
import org.switchyard.transform.TransformResolver;
import org.switchyard.transform.TransformSequence;
import org.switchyard.transform.Transformer;
import org.switchyard.transform.TransformerRegistry;

public class BaseTransformResolver
implements TransformResolver {
    public static final int DEFAULT_HOPS = 2;
    private int _hops = 2;
    private TransformerRegistry _registry;

    public BaseTransformResolver() {
    }

    public BaseTransformResolver(int numHops) {
        this._hops = numHops;
    }

    public BaseTransformResolver(TransformerRegistry registry) {
        this._registry = registry;
    }

    public BaseTransformResolver(TransformerRegistry registry, int numHops) {
        this._registry = registry;
        this._hops = numHops;
    }

    public TransformSequence resolveSequence(QName from, QName to) {
        if (from == null || to == null) {
            return null;
        }
        if (this._registry.hasTransformer(from, to)) {
            return TransformSequence.from((QName)from).to(to);
        }
        TransformSequence transformSequence = null;
        LinkedList<QName> path = new LinkedList<QName>();
        if (this.resolvePath(path, from, to, this._hops)) {
            transformSequence = TransformSequence.from((QName)from);
            for (QName type : path) {
                transformSequence.to(type);
            }
        }
        return transformSequence;
    }

    public TransformerRegistry getRegistry() {
        return this._registry;
    }

    public void setRegistry(TransformerRegistry registry) {
        this._registry = registry;
    }

    boolean resolvePath(LinkedList<QName> path, QName fromType, QName toType, int limit) {
        if (limit < 0) {
            return false;
        }
        --limit;
        if (fromType.equals(toType)) {
            return true;
        }
        for (Transformer fromT : this._registry.getTransformersFrom(fromType)) {
            if (!this.resolvePath(path, fromT.getTo(), toType, limit)) continue;
            path.addFirst(fromT.getTo());
            return true;
        }
        return false;
    }
}

