/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.management.mbeans.bundles.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.karaf.management.mbeans.bundles.BundlesMBean;
import org.apache.karaf.management.mbeans.bundles.internal.BundleStateListener;
import org.apache.karaf.management.mbeans.bundles.internal.BundlesSelector;
import org.apache.karaf.util.bundles.BundleUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;

public class BundlesMBeanImpl
extends StandardMBean
implements BundlesMBean {
    private BundleContext bundleContext;
    private List<BundleStateListener.Factory> bundleStateListenerFactories;

    public BundlesMBeanImpl() throws NotCompliantMBeanException {
        super(BundlesMBean.class);
    }

    public void setBundleStateListenerFactories(List<BundleStateListener.Factory> bundleStateListenerFactories) {
        this.bundleStateListenerFactories = bundleStateListenerFactories;
    }

    @Override
    public TabularData getBundles() throws Exception {
        ServiceReference startLevelReference = this.bundleContext.getServiceReference(StartLevel.class.getName());
        StartLevel startLevel = null;
        if (startLevelReference != null) {
            startLevel = (StartLevel)this.bundleContext.getService(startLevelReference);
        }
        ArrayList<String> headers = new ArrayList<String>();
        headers.add("ID");
        headers.add("Name");
        headers.add("Version");
        headers.add("Start Level");
        headers.add("State");
        ArrayList<String> descriptions = new ArrayList<String>();
        descriptions.add("ID of the Bundle");
        descriptions.add("Name of the Bundle");
        descriptions.add("Version of the Bundle");
        descriptions.add("Start Level of the Bundle");
        descriptions.add("Current State of the Bundle");
        ArrayList<SimpleType<Object>> types = new ArrayList<SimpleType<Object>>();
        types.add(SimpleType.LONG);
        types.add(SimpleType.STRING);
        types.add(SimpleType.STRING);
        types.add(SimpleType.INTEGER);
        types.add(SimpleType.STRING);
        for (BundleStateListener.Factory factory : this.bundleStateListenerFactories) {
            BundleStateListener listener = factory.getListener();
            if (listener == null) continue;
            headers.add(listener.getName());
            descriptions.add(listener.getDescription());
            types.add(SimpleType.STRING);
        }
        CompositeType bundleType = new CompositeType("Bundle", "OSGi Bundle", headers.toArray(new String[0]), descriptions.toArray(new String[0]), types.toArray(new OpenType[0]));
        TabularType tableType = new TabularType("Bundles", "Tables of all Bundles", bundleType, new String[]{"ID"});
        TabularDataSupport table = new TabularDataSupport(tableType);
        Bundle[] bundles = this.bundleContext.getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            try {
                int bundleState;
                ArrayList<Object> values = new ArrayList<Object>();
                values.add(bundles[i].getBundleId());
                values.add(bundles[i].getSymbolicName());
                values.add(bundles[i].getVersion().toString());
                int bundleStartLevel = 1;
                if (startLevel != null) {
                    bundleStartLevel = startLevel.getBundleStartLevel(bundles[i]);
                }
                String bundleStateString = (bundleState = bundles[i].getState()) == 32 ? "ACTIVE" : (bundleState == 2 ? "INSTALLED" : (bundleState == 4 ? "RESOLVED" : (bundleState == 8 ? "STARTING" : (bundleState == 16 ? "STOPPING" : "UNKNOWN"))));
                values.add(bundleStartLevel);
                values.add(bundleStateString);
                for (BundleStateListener.Factory factory : this.bundleStateListenerFactories) {
                    BundleStateListener listener = factory.getListener();
                    if (listener == null) continue;
                    String state = listener.getState(bundles[i]);
                    if (state == null) {
                        state = "";
                    }
                    values.add(state);
                }
                CompositeDataSupport data = new CompositeDataSupport(bundleType, headers.toArray(new String[0]), values.toArray(new Object[0]));
                table.put(data);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.bundleContext.ungetService(startLevelReference);
        return table;
    }

    @Override
    public TabularData list() throws Exception {
        return this.getBundles();
    }

    @Override
    public int getStartLevel(String bundleId) throws Exception {
        ServiceReference startLevelReference = this.bundleContext.getServiceReference(StartLevel.class.getName());
        if (startLevelReference == null) {
            throw new IllegalStateException("StartLevel service is not available");
        }
        StartLevel startLevel = (StartLevel)this.bundleContext.getService(startLevelReference);
        if (startLevel == null) {
            throw new IllegalStateException("StartLevel service is not available");
        }
        BundlesSelector selector = new BundlesSelector(this.bundleContext);
        List<Bundle> bundles = selector.selectBundles(bundleId);
        if (bundles.size() != 1) {
            throw new IllegalArgumentException("Provided bundle Id doesn't return any bundle or more than one bundle selected");
        }
        int bundleStartLevel = startLevel.getBundleStartLevel(bundles.get(0));
        this.bundleContext.ungetService(startLevelReference);
        return bundleStartLevel;
    }

    @Override
    public void setStartLevel(String bundleId, int bundleStartLevel) throws Exception {
        ServiceReference startLevelReference = this.bundleContext.getServiceReference(StartLevel.class.getName());
        if (startLevelReference == null) {
            throw new IllegalStateException("StartLevel service is not available");
        }
        StartLevel startLevel = (StartLevel)this.bundleContext.getService(startLevelReference);
        if (startLevel == null) {
            throw new IllegalStateException("StartLevel service is not available");
        }
        BundlesSelector selector = new BundlesSelector(this.bundleContext);
        List<Bundle> bundles = selector.selectBundles(bundleId);
        for (Bundle bundle : bundles) {
            startLevel.setBundleStartLevel(bundle, bundleStartLevel);
        }
        this.bundleContext.ungetService(startLevelReference);
    }

    @Override
    public void refresh() throws Exception {
        ServiceReference packageAdminReference = this.getBundleContext().getServiceReference(PackageAdmin.class.getName());
        if (packageAdminReference == null) {
            throw new IllegalStateException("PackageAdmin service is not available");
        }
        PackageAdmin packageAdmin = (PackageAdmin)this.bundleContext.getService(packageAdminReference);
        if (packageAdmin == null) {
            throw new IllegalStateException("PackageAdmin service is not available");
        }
        packageAdmin.refreshPackages(null);
        this.getBundleContext().ungetService(packageAdminReference);
    }

    @Override
    public void refresh(String bundleId) throws Exception {
        ServiceReference packageAdminReference = this.getBundleContext().getServiceReference(PackageAdmin.class.getName());
        if (packageAdminReference == null) {
            throw new IllegalStateException("PackageAdmin service is not available");
        }
        PackageAdmin packageAdmin = (PackageAdmin)this.bundleContext.getService(packageAdminReference);
        if (packageAdmin == null) {
            throw new IllegalStateException("PackageAdmin service is not available");
        }
        BundlesSelector selector = new BundlesSelector(this.bundleContext);
        List<Bundle> bundles = selector.selectBundles(bundleId);
        Bundle[] bundlesArray = new Bundle[bundles.size()];
        packageAdmin.refreshPackages(bundles.toArray(bundlesArray));
        this.getBundleContext().ungetService(packageAdminReference);
    }

    @Override
    public void update(String bundleId) throws Exception {
        this.update(bundleId, null);
    }

    @Override
    public void update(String bundleId, String location) throws Exception {
        BundlesSelector selector = new BundlesSelector(this.bundleContext);
        List<Bundle> bundles = selector.selectBundles(bundleId);
        if (location == null) {
            for (Bundle bundle : bundles) {
                BundleUtils.update(bundle);
            }
            return;
        }
        if (bundles.size() != 1) {
            throw new IllegalArgumentException("Provided bundle Id doesn't return any bundle or more than one bundle selected");
        }
        BundleUtils.update(bundles.get(0), new URL(location));
    }

    @Override
    public void resolve() throws Exception {
        ServiceReference packageAdminReference = this.getBundleContext().getServiceReference(PackageAdmin.class.getName());
        if (packageAdminReference == null) {
            throw new IllegalStateException("PackageAdmin service is not available");
        }
        PackageAdmin packageAdmin = (PackageAdmin)this.bundleContext.getService(packageAdminReference);
        if (packageAdmin == null) {
            throw new IllegalStateException("PackageAdmin service is not available");
        }
        packageAdmin.resolveBundles(null);
        this.getBundleContext().ungetService(packageAdminReference);
    }

    @Override
    public void resolve(String bundleId) throws Exception {
        ServiceReference packageAdminReference = this.getBundleContext().getServiceReference(PackageAdmin.class.getName());
        if (packageAdminReference == null) {
            throw new IllegalStateException("PackageAdmin service is not available");
        }
        PackageAdmin packageAdmin = (PackageAdmin)this.bundleContext.getService(packageAdminReference);
        if (packageAdmin == null) {
            throw new IllegalStateException("PackageAdmin service is not available");
        }
        BundlesSelector selector = new BundlesSelector(this.bundleContext);
        List<Bundle> bundles = selector.selectBundles(bundleId);
        Bundle[] bundlesArray = new Bundle[bundles.size()];
        packageAdmin.resolveBundles(bundles.toArray(bundlesArray));
        this.getBundleContext().ungetService(packageAdminReference);
    }

    @Override
    public void restart(String bundleId) throws Exception {
        BundlesSelector selector = new BundlesSelector(this.bundleContext);
        List<Bundle> bundles = selector.selectBundles(bundleId);
        for (Bundle bundle : bundles) {
            bundle.stop();
            bundle.start();
        }
    }

    @Override
    public long install(String url) throws Exception {
        return this.install(url, false);
    }

    @Override
    public long install(String url, boolean start) throws Exception {
        Bundle bundle = this.bundleContext.installBundle(url, null);
        if (start) {
            bundle.start();
        }
        return bundle.getBundleId();
    }

    @Override
    public void start(String bundleId) throws Exception {
        BundlesSelector selector = new BundlesSelector(this.bundleContext);
        List<Bundle> bundles = selector.selectBundles(bundleId);
        for (Bundle bundle : bundles) {
            bundle.start();
        }
    }

    @Override
    public void stop(String bundleId) throws Exception {
        BundlesSelector selector = new BundlesSelector(this.bundleContext);
        List<Bundle> bundles = selector.selectBundles(bundleId);
        for (Bundle bundle : bundles) {
            bundle.stop();
        }
    }

    @Override
    public void uninstall(String bundleId) throws Exception {
        BundlesSelector selector = new BundlesSelector(this.bundleContext);
        List<Bundle> bundles = selector.selectBundles(bundleId);
        for (Bundle bundle : bundles) {
            bundle.uninstall();
        }
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

