/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer;

import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.injection.CurrentInjectionPoint;
import org.jboss.weld.injection.DynamicInjectionPoint;
import org.jboss.weld.injection.ThreadLocalStack;
import org.jboss.weld.injection.producer.DefaultInjector;
import org.jboss.weld.manager.BeanManagerImpl;

public class StatelessSessionBeanInjector<T>
extends DefaultInjector<T> {
    private final CurrentInjectionPoint currentInjectionPoint;
    private boolean pushDynamicInjectionPoints;

    public StatelessSessionBeanInjector(EnhancedAnnotatedType<T> type, Bean<T> bean, BeanManagerImpl beanManager) {
        super(type, bean, beanManager);
        this.currentInjectionPoint = beanManager.getServices().get(CurrentInjectionPoint.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inject(T instance, CreationalContext<T> ctx, BeanManagerImpl manager, SlimAnnotatedType<T> type, InjectionTarget<T> injectionTarget) {
        ThreadLocalStack.ThreadLocalStackReference<DynamicInjectionPoint> stack = null;
        if (this.pushDynamicInjectionPoints) {
            stack = this.currentInjectionPoint.push(new DynamicInjectionPoint(manager));
        }
        try {
            super.inject(instance, ctx, manager, type, injectionTarget);
        }
        finally {
            if (this.pushDynamicInjectionPoints) {
                stack.pop();
            }
        }
    }

    @Override
    public void registerInjectionPoints(Set<InjectionPoint> injectionPoints) {
        super.registerInjectionPoints(injectionPoints);
        this.pushDynamicInjectionPoints = this.hasInjectionPointMetadata(injectionPoints);
    }

    private boolean hasInjectionPointMetadata(Set<InjectionPoint> injectionPoints) {
        for (InjectionPoint injectionPoint : injectionPoints) {
            if (injectionPoint.getType() != InjectionPoint.class) continue;
            return true;
        }
        return false;
    }
}

