/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.commands;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;

@Command(scope="shell", name="date", description="Display the current time in the given FORMAT")
public class DateAction
extends AbstractAction {
    @Option(name="-d", aliases={"--date"}, description="Display time described, not now", multiValued=false, required=false)
    private String date;
    @Argument(index=0, name="format", description="Output format", multiValued=false, required=false)
    private String format;

    protected Object doExecute() throws Exception {
        Date d = this.date == null || this.date.equalsIgnoreCase("now") ? new Date() : (this.date.startsWith("@") ? new Date(Long.parseLong(this.date.substring(1))) : new Date(this.date));
        if (this.format == null) {
            System.out.println(d);
        } else {
            this.format = this.format.replaceAll("%a", "EEE");
            this.format = this.format.replaceAll("%A", "EEEEEEE");
            this.format = this.format.replaceAll("%b", "MMM");
            this.format = this.format.replaceAll("%B", "MMMMMMM");
            this.format = this.format.replaceAll("%c", "MMM EEE d HH:mm:ss yyyy");
            this.format = this.format.replaceAll("%C", "yy");
            this.format = this.format.replaceAll("%d", "dd");
            this.format = this.format.replaceAll("%D", "MM/dd/yy");
            this.format = this.format.replaceAll("%e", "dd");
            this.format = this.format.replaceAll("%F", "yyyy-MM-dd");
            this.format = this.format.replaceAll("%g", "YY");
            this.format = this.format.replaceAll("%G", "YYYY");
            this.format = this.format.replaceAll("%h", "MMM");
            this.format = this.format.replaceAll("%H", "HH");
            this.format = this.format.replaceAll("%I", "hh");
            this.format = this.format.replaceAll("%j", "DDD");
            this.format = this.format.replaceAll("%k", "HH");
            this.format = this.format.replaceAll("%l", "hh");
            this.format = this.format.replaceAll("%m", "MM");
            this.format = this.format.replaceAll("%M", "mm");
            this.format = this.format.replaceAll("%n", "\n");
            this.format = this.format.replaceAll("%N", "S");
            this.format = this.format.replaceAll("%p", "aa");
            this.format = this.format.replaceAll("%P", "aa");
            this.format = this.format.replaceAll("%r", "hh:mm:ss aa");
            this.format = this.format.replaceAll("%R", "HH:mm");
            this.format = this.format.replaceAll("%s", "S");
            this.format = this.format.replaceAll("%S", "ss");
            this.format = this.format.replaceAll("%t", "\t");
            this.format = this.format.replaceAll("%T", "HH:mm:ss");
            this.format = this.format.replaceAll("%u", "u");
            this.format = this.format.replaceAll("%U", "w");
            this.format = this.format.replaceAll("%V", "W");
            this.format = this.format.replaceAll("%w", "u");
            this.format = this.format.replaceAll("%W", "w");
            this.format = this.format.replaceAll("%x", "MM/dd/yy");
            this.format = this.format.replaceAll("%X", "HH:mm:ss");
            this.format = this.format.replaceAll("%y", "yy");
            this.format = this.format.replaceAll("%Y", "yyyy");
            this.format = this.format.replaceAll("%z", "X");
            this.format = this.format.replaceAll("%:z", "XXX");
            this.format = this.format.replaceAll("%::z", "XXXX");
            this.format = this.format.replaceAll("%:::z", "XXXX");
            this.format = this.format.replaceAll("%Z", "z");
            SimpleDateFormat df = new SimpleDateFormat(this.format);
            System.out.println(df.format(d));
        }
        return null;
    }
}

