/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.context.transaction.impl;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.TransactionRequiredException;
import javax.transaction.Synchronization;
import javax.transaction.TransactionSynchronizationRegistry;
import org.apache.aries.jpa.container.context.JTAPersistenceContextManager;
import org.apache.aries.jpa.container.context.impl.NLS;
import org.apache.aries.jpa.container.context.transaction.impl.DestroyCallback;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JTAPersistenceContextRegistry
extends ServiceTracker
implements JTAPersistenceContextManager {
    private static final Logger _logger = LoggerFactory.getLogger((String)"org.apache.aries.jpa.container.context");
    private static final TSRKey EMF_MAP_KEY = new TSRKey();
    private final AtomicReference<TransactionSynchronizationRegistry> tranRegistry = new AtomicReference();
    private AtomicReference<ServiceReference> tranRegistryRef = new AtomicReference();

    public JTAPersistenceContextRegistry(BundleContext context) {
        super(context, TransactionSynchronizationRegistry.class.getName(), null);
        this.open();
    }

    public final EntityManager getExistingPersistenceContext(EntityManagerFactory emf) {
        this.ensureTransaction();
        Map<EntityManagerFactory, EntityManager> contextsForTransaction = this.getContextsForTransaction(this.tranRegistry.get());
        return contextsForTransaction.get(emf);
    }

    public final void manageExistingPersistenceContext(EntityManagerFactory emf, EntityManager em) throws TransactionRequiredException {
        this.ensureTransaction();
        Map<EntityManagerFactory, EntityManager> contextsForTransaction = this.getContextsForTransaction(this.tranRegistry.get());
        if (contextsForTransaction.containsKey(emf)) {
            throw new IllegalStateException(NLS.MESSAGES.getMessage("existing.persistence.context", new Object[0]));
        }
        em.joinTransaction();
        contextsForTransaction.put(emf, em);
    }

    private void ensureTransaction() throws TransactionRequiredException {
        if (!this.isTransactionActive()) {
            if (this.jtaIntegrationAvailable()) {
                throw new TransactionRequiredException(NLS.MESSAGES.getMessage("no.active.transaction", new Object[0]));
            }
            throw new TransactionRequiredException(NLS.MESSAGES.getMessage("no.transaction.manager", new Object[0]));
        }
    }

    public final EntityManager getCurrentPersistenceContext(EntityManagerFactory persistenceUnit, Map<?, ?> properties, AtomicLong activeCount, DestroyCallback cbk) throws TransactionRequiredException {
        EntityManager toReturn = this.getExistingPersistenceContext(persistenceUnit);
        if (toReturn != null) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Re-using a persistence context for transaction " + this.tranRegistry.get().getTransactionKey());
            }
            return toReturn;
        }
        TransactionSynchronizationRegistry tsr = this.tranRegistry.get();
        Map<EntityManagerFactory, EntityManager> contextsForTransaction = this.getContextsForTransaction(tsr);
        EntityManager entityManager = toReturn = properties == null ? persistenceUnit.createEntityManager() : persistenceUnit.createEntityManager(properties);
        if (_logger.isDebugEnabled()) {
            _logger.debug("Created a new persistence context {} for transaction {}.", new Object[]{toReturn, tsr.getTransactionKey()});
        }
        try {
            tsr.registerInterposedSynchronization((Synchronization)new EntityManagerClearUp(toReturn, activeCount, cbk));
        }
        catch (IllegalStateException e) {
            String message = NLS.MESSAGES.getMessage("unable.to.register.synchronization", new Object[]{tsr.getTransactionKey()});
            _logger.warn(message);
            toReturn.close();
            throw new TransactionRequiredException(message);
        }
        contextsForTransaction.put(persistenceUnit, toReturn);
        activeCount.incrementAndGet();
        return toReturn;
    }

    private Map<EntityManagerFactory, EntityManager> getContextsForTransaction(TransactionSynchronizationRegistry tsr) {
        IdentityHashMap contextsForTransaction = (IdentityHashMap)tsr.getResource((Object)EMF_MAP_KEY);
        if (contextsForTransaction == null) {
            contextsForTransaction = new IdentityHashMap();
            try {
                tsr.putResource((Object)EMF_MAP_KEY, contextsForTransaction);
            }
            catch (IllegalStateException e) {
                String message = NLS.MESSAGES.getMessage("tran.not.active", new Object[]{tsr.getTransactionKey()});
                _logger.warn(message);
                throw new TransactionRequiredException(message);
            }
        }
        return contextsForTransaction;
    }

    public final boolean isTransactionActive() {
        TransactionSynchronizationRegistry tsr = this.tranRegistry.get();
        return tsr != null && tsr.getTransactionKey() != null;
    }

    public final boolean jtaIntegrationAvailable() {
        return this.tranRegistry.get() != null;
    }

    public final Object addingService(ServiceReference ref) {
        if (this.tranRegistryRef.compareAndSet(null, ref)) {
            TransactionSynchronizationRegistry tsr = (TransactionSynchronizationRegistry)this.context.getService(ref);
            if (tsr != null) {
                if (this.tranRegistry.compareAndSet(null, tsr)) {
                    _logger.info(NLS.MESSAGES.getMessage("tran.sync.registry.arrived", new Object[]{ref}));
                } else {
                    this.tranRegistry.set(tsr);
                    _logger.warn(NLS.MESSAGES.getMessage("tran.sync.registry.replace", new Object[]{ref}));
                }
            } else {
                this.tranRegistryRef.compareAndSet(ref, null);
            }
        }
        return ref;
    }

    public final void removedService(ServiceReference reference, Object o) {
        if (this.tranRegistryRef.get() == reference) {
            ServiceReference[] refs = this.getServiceReferences();
            ServiceReference chosenRef = null;
            TransactionSynchronizationRegistry replacement = null;
            if (refs != null) {
                for (ServiceReference ref : refs) {
                    if (ref == reference || (replacement = (TransactionSynchronizationRegistry)this.context.getService(ref)) == null) continue;
                    chosenRef = ref;
                    break;
                }
            }
            if (replacement == null) {
                TransactionSynchronizationRegistry old = this.tranRegistry.get();
                this.tranRegistryRef.set(null);
                this.tranRegistry.compareAndSet(old, null);
                _logger.warn(NLS.MESSAGES.getMessage("tran.sync.registry.gone", new Object[0]));
            } else {
                this.tranRegistryRef.set(chosenRef);
                this.tranRegistry.set(replacement);
                _logger.warn(NLS.MESSAGES.getMessage("tran.sync.registry.replace", new Object[]{chosenRef}));
            }
            this.context.ungetService(reference);
            if (replacement == null) {
                ServiceReference[] retryRefs = this.getServiceReferences();
                if (refs != null) {
                    for (ServiceReference r : retryRefs) {
                        if (r == reference) continue;
                        this.addingService(r);
                        if (this.tranRegistryRef.get() != null) break;
                    }
                }
            }
        }
    }

    private static final class EntityManagerClearUp
    implements Synchronization {
        private final EntityManager context;
        private final AtomicLong activeCount;
        private final DestroyCallback callback;

        public EntityManagerClearUp(EntityManager em, AtomicLong instanceCount, DestroyCallback cbk) {
            this.context = em;
            this.activeCount = instanceCount;
            this.callback = cbk;
        }

        public final void beforeCompletion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void afterCompletion(int arg0) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Clearing up EntityManager {} as the transaction has completed.", new Object[]{this.context});
            }
            try {
                this.activeCount.decrementAndGet();
                this.callback.callback();
            }
            catch (Throwable throwable) {
                try {
                    this.context.close();
                }
                catch (Exception e) {
                    _logger.warn(NLS.MESSAGES.getMessage("error.closing.entity.manager", new Object[]{this.context.getProperties()}), (Throwable)e);
                }
                throw throwable;
            }
            try {
                this.context.close();
            }
            catch (Exception e) {
                _logger.warn(NLS.MESSAGES.getMessage("error.closing.entity.manager", new Object[]{this.context.getProperties()}), (Throwable)e);
            }
        }
    }

    private static final class TSRKey {
        private TSRKey() {
        }

        public final boolean equals(Object o) {
            return this == o;
        }

        public final int hashCode() {
            return -559038737;
        }
    }
}

