/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl.ssl;

import java.nio.ByteBuffer;
import org.apache.qpid.proton.engine.TransportException;
import org.apache.qpid.proton.engine.impl.TransportWrapper;
import org.apache.qpid.proton.engine.impl.ssl.SslTransportWrapper;

public class SslHandshakeSniffingTransportWrapper
implements SslTransportWrapper {
    private static final int MINIMUM_LENGTH_FOR_DETERMINATION = 5;
    private final SslTransportWrapper _secureTransportWrapper;
    private final TransportWrapper _plainTransportWrapper;
    private boolean _tail_closed = false;
    private boolean _head_closed = false;
    private TransportWrapper _selectedTransportWrapper;
    private final ByteBuffer _determinationBuffer = ByteBuffer.allocate(5);

    SslHandshakeSniffingTransportWrapper(SslTransportWrapper secureTransportWrapper, TransportWrapper plainTransportWrapper) {
        this._secureTransportWrapper = secureTransportWrapper;
        this._plainTransportWrapper = plainTransportWrapper;
    }

    @Override
    public int capacity() {
        if (this.isDeterminationMade()) {
            return this._selectedTransportWrapper.capacity();
        }
        if (this._tail_closed) {
            return -1;
        }
        return this._determinationBuffer.remaining();
    }

    @Override
    public int position() {
        if (this.isDeterminationMade()) {
            return this._selectedTransportWrapper.position();
        }
        if (this._tail_closed) {
            return -1;
        }
        return this._determinationBuffer.position();
    }

    @Override
    public ByteBuffer tail() {
        if (this.isDeterminationMade()) {
            return this._selectedTransportWrapper.tail();
        }
        return this._determinationBuffer;
    }

    @Override
    public void process() throws TransportException {
        if (this.isDeterminationMade()) {
            this._selectedTransportWrapper.process();
        } else if (this._determinationBuffer.remaining() == 0) {
            this._determinationBuffer.flip();
            byte[] bytesInput = new byte[this._determinationBuffer.remaining()];
            this._determinationBuffer.get(bytesInput);
            this.makeSslDetermination(bytesInput);
            this._determinationBuffer.rewind();
            this._selectedTransportWrapper.tail().put(this._determinationBuffer);
            this._selectedTransportWrapper.process();
        } else if (this._tail_closed) {
            throw new TransportException("connection aborted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close_tail() {
        try {
            if (this.isDeterminationMade()) {
                this._selectedTransportWrapper.close_tail();
            }
        }
        finally {
            this._tail_closed = true;
        }
    }

    @Override
    public int pending() {
        if (this._head_closed) {
            return -1;
        }
        if (this.isDeterminationMade()) {
            return this._selectedTransportWrapper.pending();
        }
        return 0;
    }

    @Override
    public ByteBuffer head() {
        if (this.isDeterminationMade()) {
            return this._selectedTransportWrapper.head();
        }
        return null;
    }

    @Override
    public void pop(int bytes) {
        if (this.isDeterminationMade()) {
            this._selectedTransportWrapper.pop(bytes);
        } else if (bytes > 0) {
            throw new IllegalStateException("no bytes have been read");
        }
    }

    @Override
    public void close_head() {
        if (this.isDeterminationMade()) {
            this._selectedTransportWrapper.close_head();
        } else {
            this._head_closed = true;
        }
    }

    @Override
    public String getCipherName() {
        if (this.isSecureWrapperSelected()) {
            return this._secureTransportWrapper.getCipherName();
        }
        return null;
    }

    @Override
    public String getProtocolName() {
        if (this.isSecureWrapperSelected()) {
            return this._secureTransportWrapper.getProtocolName();
        }
        return null;
    }

    private boolean isSecureWrapperSelected() {
        return this._selectedTransportWrapper == this._secureTransportWrapper;
    }

    private boolean isDeterminationMade() {
        return this._selectedTransportWrapper != null;
    }

    private void makeSslDetermination(byte[] bytesInput) {
        boolean isSecure = this.checkForSslHandshake(bytesInput);
        this._selectedTransportWrapper = isSecure ? this._secureTransportWrapper : this._plainTransportWrapper;
    }

    private boolean checkForSslHandshake(byte[] buf) {
        if (buf.length >= 5) {
            boolean isSSL2Handshake = buf[2] == 1 && (buf[3] == 3 && buf[4] <= 3 || buf[3] == 2 && buf[4] == 0);
            boolean isSSL3Handshake = buf[0] == 22 && buf[1] == 3 && buf[2] <= 3;
            return isSSL2Handshake || isSSL3Handshake;
        }
        throw new IllegalArgumentException("Too few bytes (" + buf.length + ") to make SSL/plain  determination.");
    }
}

