/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.util.Set;
import org.infinispan.atomic.CopyableDeltaAware;
import org.infinispan.atomic.Delta;
import org.infinispan.atomic.DeltaAware;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.notifications.cachelistener.CacheNotifier;

public class PutKeyValueCommand
extends AbstractDataWriteCommand {
    public static final byte COMMAND_ID = 8;
    Object value;
    boolean putIfAbsent;
    CacheNotifier notifier;
    boolean successful = true;
    long lifespanMillis = -1L;
    long maxIdleTimeMillis = -1L;
    private boolean ignorePreviousValue = false;

    public PutKeyValueCommand() {
    }

    public PutKeyValueCommand(Object key, Object value, boolean putIfAbsent, CacheNotifier notifier, long lifespanMillis, long maxIdleTimeMillis, Set<Flag> flags) {
        super(key, flags);
        this.setValue(value);
        this.putIfAbsent = putIfAbsent;
        this.notifier = notifier;
        this.lifespanMillis = lifespanMillis;
        this.maxIdleTimeMillis = maxIdleTimeMillis;
    }

    public void init(CacheNotifier notifier) {
        this.notifier = notifier;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
        if (value instanceof DeltaAware) {
            this.setFlags(Flag.DELTA_WRITE);
        }
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitPutKeyValueCommand(ctx, this);
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        Object o;
        MVCCEntry e = (MVCCEntry)ctx.lookupEntry(this.key);
        if (e == null && this.hasFlag(Flag.PUT_FOR_EXTERNAL_READ)) {
            this.successful = false;
            return null;
        }
        if (e == null) {
            return null;
        }
        Object entryValue = e.getValue();
        if (entryValue != null && this.putIfAbsent && !this.ignorePreviousValue && !e.isRemoved()) {
            e.setChanged(false);
            this.successful = false;
            return entryValue;
        }
        this.notifier.notifyCacheEntryModified(this.key, entryValue, true, ctx);
        if (this.value instanceof Delta) {
            Delta dv = (Delta)this.value;
            DeltaAware toMergeWith = null;
            if (entryValue instanceof CopyableDeltaAware) {
                toMergeWith = ((CopyableDeltaAware)entryValue).copy();
            } else if (entryValue instanceof DeltaAware) {
                toMergeWith = (DeltaAware)entryValue;
            }
            e.setValue(dv.merge(toMergeWith));
            o = entryValue;
            e.setLifespan(this.lifespanMillis);
            e.setMaxIdle(this.maxIdleTimeMillis);
        } else {
            o = e.setValue(this.value);
            if (e.isRemoved()) {
                e.setRemoved(false);
                e.setValid(true);
                o = null;
            }
            e.setLifespan(this.lifespanMillis);
            e.setMaxIdle(this.maxIdleTimeMillis);
        }
        return !this.ignorePreviousValue ? o : null;
    }

    @Override
    public byte getCommandId() {
        return 8;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.key, this.value, this.lifespanMillis, this.maxIdleTimeMillis, this.putIfAbsent, this.ignorePreviousValue, Flag.copyWithoutRemotableFlags(this.flags)};
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
        if (commandId != 8) {
            throw new IllegalStateException("Invalid method id");
        }
        this.key = parameters[0];
        this.value = parameters[1];
        this.lifespanMillis = (Long)parameters[2];
        this.maxIdleTimeMillis = (Long)parameters[3];
        this.putIfAbsent = (Boolean)parameters[4];
        this.ignorePreviousValue = (Boolean)parameters[5];
        this.flags = (Set)parameters[6];
    }

    public boolean isPutIfAbsent() {
        return this.putIfAbsent;
    }

    public void setPutIfAbsent(boolean putIfAbsent) {
        this.putIfAbsent = putIfAbsent;
    }

    public long getLifespanMillis() {
        return this.lifespanMillis;
    }

    public long getMaxIdleTimeMillis() {
        return this.maxIdleTimeMillis;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PutKeyValueCommand that = (PutKeyValueCommand)o;
        if (this.lifespanMillis != that.lifespanMillis) {
            return false;
        }
        if (this.maxIdleTimeMillis != that.maxIdleTimeMillis) {
            return false;
        }
        if (this.putIfAbsent != that.putIfAbsent) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.putIfAbsent ? 1 : 0);
        result = 31 * result + (int)(this.lifespanMillis ^ this.lifespanMillis >>> 32);
        result = 31 * result + (int)(this.maxIdleTimeMillis ^ this.maxIdleTimeMillis >>> 32);
        return result;
    }

    @Override
    public String toString() {
        return "PutKeyValueCommand{key=" + this.key + ", value=" + this.value + ", flags=" + this.flags + ", putIfAbsent=" + this.putIfAbsent + ", lifespanMillis=" + this.lifespanMillis + ", maxIdleTimeMillis=" + this.maxIdleTimeMillis + ", successful=" + this.successful + ", ignorePreviousValue=" + this.ignorePreviousValue + "}";
    }

    @Override
    public boolean isSuccessful() {
        return this.successful;
    }

    @Override
    public boolean isConditional() {
        return this.putIfAbsent;
    }

    @Override
    public boolean isIgnorePreviousValue() {
        return this.ignorePreviousValue;
    }

    @Override
    public void setIgnorePreviousValue(boolean ignorePreviousValue) {
        this.ignorePreviousValue = ignorePreviousValue;
    }
}

