/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.parsing;

public class Namespace {
    public static final String INFINISPAN_NS_BASE_URI = "urn:infinispan:config";
    private final String base;
    private final String rootElement;
    private final int major;
    private final int minor;

    public Namespace(String rootElement) {
        this("", rootElement, 0, 0);
    }

    public Namespace(String base, String rootElement, int major, int minor) {
        this.base = base;
        this.rootElement = rootElement;
        this.major = major;
        this.minor = minor;
    }

    public Namespace(String base, String module, String rootElement, int major, int minor) {
        this(base + ":" + module, rootElement, major, minor);
    }

    public String getBase() {
        return this.base;
    }

    public String getRootElement() {
        return this.rootElement;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public String getUri() {
        return this.base == "" ? this.base : this.base + ":" + this.major + "." + this.minor;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.base == null ? 0 : this.base.hashCode());
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        result = 31 * result + (this.rootElement == null ? 0 : this.rootElement.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Namespace other = (Namespace)obj;
        if (this.base == null ? other.base != null : !this.base.equals(other.base)) {
            return false;
        }
        if (this.major != other.major) {
            return false;
        }
        if (this.minor != other.minor) {
            return false;
        }
        return !(this.rootElement == null ? other.rootElement != null : !this.rootElement.equals(other.rootElement));
    }
}

