/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.connection;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.hibernate.HibernateException;
import org.hibernate.ejb.internal.EntityManagerMessageLogger;
import org.hibernate.service.jdbc.connections.internal.DatasourceConnectionProviderImpl;
import org.jboss.logging.Logger;

public class InjectedDataSourceConnectionProvider
extends DatasourceConnectionProviderImpl {
    private static final EntityManagerMessageLogger LOG = (EntityManagerMessageLogger)Logger.getMessageLogger(EntityManagerMessageLogger.class, (String)InjectedDataSourceConnectionProvider.class.getName());
    private String user;
    private String pass;

    public void setDataSource(DataSource ds) {
        super.setDataSource(ds);
    }

    public void configure(Properties props) throws HibernateException {
        this.user = props.getProperty("hibernate.connection.username");
        this.pass = props.getProperty("hibernate.connection.password");
        if (this.getDataSource() == null) {
            throw new HibernateException("No datasource provided");
        }
        LOG.usingProvidedDataSource();
    }

    public Connection getConnection() throws SQLException {
        if (this.user != null || this.pass != null) {
            return this.getDataSource().getConnection(this.user, this.pass);
        }
        return this.getDataSource().getConnection();
    }
}

