/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.management;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.rmi.server.RMIServerSocketFactory;
import java.security.GeneralSecurityException;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import org.apache.karaf.jaas.config.KeystoreInstance;
import org.apache.karaf.jaas.config.KeystoreManager;
import org.apache.karaf.management.KarafMBeanServerGuard;
import org.apache.karaf.management.internal.MBeanInvocationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorServerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectorServerFactory.class);
    private MBeanServer server;
    private KarafMBeanServerGuard guard;
    private String serviceUrl;
    private String rmiServerHost;
    private Map environment;
    private ObjectName objectName;
    private boolean threaded = false;
    private boolean daemon = false;
    private JMXConnectorServer connectorServer;
    private long keyStoreAvailabilityTimeout = 5000L;
    private AuthenticatorType authenticatorType = AuthenticatorType.PASSWORD;
    private boolean secured;
    private KeystoreManager keystoreManager;
    private String algorithm;
    private String secureProtocol;
    private String keyStore;
    private String trustStore;
    private String keyAlias;

    public MBeanServer getServer() {
        return this.server;
    }

    public void setServer(MBeanServer server) {
        this.server = server;
    }

    public KarafMBeanServerGuard getGuard() {
        return this.guard;
    }

    public void setGuard(KarafMBeanServerGuard guard) {
        this.guard = guard;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public Map getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map environment) {
        this.environment = environment;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
    }

    public boolean isThreaded() {
        return this.threaded;
    }

    public void setThreaded(boolean threaded) {
        this.threaded = threaded;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public String getAuthenticatorType() {
        return this.authenticatorType.name().toLowerCase();
    }

    public void setAuthenticatorType(String value) {
        this.authenticatorType = AuthenticatorType.valueOf(value.toUpperCase());
    }

    public void setKeyStoreAvailabilityTimeout(long keyStoreAvailabilityTimeout) {
        this.keyStoreAvailabilityTimeout = keyStoreAvailabilityTimeout;
    }

    public boolean isSecured() {
        return this.secured;
    }

    public void setSecured(boolean secured) {
        this.secured = secured;
    }

    public void setKeystoreManager(KeystoreManager keystoreManager) {
        this.keystoreManager = keystoreManager;
    }

    public KeystoreManager getKeystoreManager() {
        return this.keystoreManager;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(String trustStore) {
        this.trustStore = trustStore;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = "default".equalsIgnoreCase(algorithm) ? KeyManagerFactory.getDefaultAlgorithm() : algorithm;
    }

    public String getSecureProtocol() {
        return this.secureProtocol;
    }

    public void setSecureProtocol(String secureProtocol) {
        this.secureProtocol = secureProtocol;
    }

    private boolean isClientAuth() {
        return this.authenticatorType.equals((Object)AuthenticatorType.CERTIFICATE);
    }

    public void init() throws Exception {
        if (this.server == null) {
            throw new IllegalArgumentException("server must be set");
        }
        this.setupKarafRMIServerSocketFactory();
        if (this.isClientAuth()) {
            this.secured = true;
        }
        if (!AuthenticatorType.PASSWORD.equals((Object)this.authenticatorType)) {
            this.environment.remove("jmx.remote.authenticator");
        }
        this.doInit();
    }

    synchronized void doInit() throws Exception {
        JMXServiceURL url = new JMXServiceURL(this.serviceUrl);
        if (this.secured) {
            try {
                this.setupSsl();
            }
            catch (Exception e) {
                LOGGER.info("Can't init JMXConnectorServer with SSL enabled: " + e.getMessage());
                return;
            }
        }
        MBeanInvocationHandler handler = new MBeanInvocationHandler(this.server, this.guard);
        MBeanServer guardedServer = (MBeanServer)Proxy.newProxyInstance(this.server.getClass().getClassLoader(), new Class[]{MBeanServer.class}, (InvocationHandler)handler);
        if (this.connectorServer != null) {
            this.destroy();
        }
        this.connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url, this.environment, guardedServer);
        if (this.objectName != null) {
            try {
                this.server.registerMBean(this.connectorServer, this.objectName);
            }
            catch (Exception e) {
                LOGGER.info("Can't register JMXConnectorServer: " + e.getMessage());
            }
        }
        try {
            if (this.threaded) {
                Thread connectorThread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            Thread.currentThread().setContextClassLoader(ConnectorServerFactory.class.getClassLoader());
                            ConnectorServerFactory.this.connectorServer.start();
                        }
                        catch (IOException ex) {
                            if (ex.getCause() instanceof BindException) {
                                int endIndex = ex.getMessage().indexOf("nested exception is");
                                if (endIndex > ex.getMessage().length() || endIndex < 0) {
                                    endIndex = ex.getMessage().length();
                                }
                                throw new RuntimeException("\n" + ex.getMessage().substring(0, endIndex) + "\nYou may have started two containers.  If you need to start a second container or the default ports are already in use " + "update the config file etc/org.apache.karaf.management.cfg and change the Registry Port and Server Port to unused ports");
                            }
                            throw new RuntimeException("Could not start JMX connector server", ex);
                        }
                    }
                };
                connectorThread.setName("JMX Connector Thread [" + this.serviceUrl + "]");
                connectorThread.setDaemon(this.daemon);
                connectorThread.start();
            } else {
                this.connectorServer.start();
            }
        }
        catch (Exception ex) {
            this.doUnregister(this.objectName);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        try {
            this.connectorServer.stop();
        }
        finally {
            this.doUnregister(this.objectName);
        }
    }

    protected void doUnregister(ObjectName objectName) {
        try {
            if (this.objectName != null && this.server.isRegistered(objectName)) {
                this.server.unregisterMBean(objectName);
            }
        }
        catch (JMException jMException) {
            // empty catch block
        }
    }

    private void setupSsl() throws GeneralSecurityException {
        SSLServerSocketFactory sslServerSocketFactory = this.keystoreManager.createSSLServerFactory(null, this.secureProtocol, this.algorithm, this.keyStore, this.keyAlias, this.trustStore, this.keyStoreAvailabilityTimeout);
        KarafSslRMIServerSocketFactory rmiServerSocketFactory = new KarafSslRMIServerSocketFactory(sslServerSocketFactory, this.isClientAuth(), this.getRmiServerHost());
        SslRMIClientSocketFactory rmiClientSocketFactory = new SslRMIClientSocketFactory();
        this.environment.put("jmx.remote.rmi.server.socket.factory", rmiServerSocketFactory);
        this.environment.put("jmx.remote.rmi.client.socket.factory", rmiClientSocketFactory);
    }

    private void setupKarafRMIServerSocketFactory() {
        KarafRMIServerSocketFactory rmiServerSocketFactory = new KarafRMIServerSocketFactory(this.getRmiServerHost());
        this.environment.put("jmx.remote.rmi.server.socket.factory", rmiServerSocketFactory);
    }

    public String getRmiServerHost() {
        return this.rmiServerHost;
    }

    public void setRmiServerHost(String rmiServerHost) {
        this.rmiServerHost = rmiServerHost;
    }

    public void register(KeystoreInstance keystore, Map<String, ?> properties) {
        if (this.secured) {
            LOGGER.info("Found new keystore: {}. Re-initializing.", (Object)keystore.getName());
            try {
                class SSLSetupThread
                extends Thread {
                    ConnectorServerFactory factory;

                    SSLSetupThread(ConnectorServerFactory factory) {
                        this.factory = factory;
                    }

                    @Override
                    public void run() {
                        try {
                            this.factory.doInit();
                        }
                        catch (Exception e) {
                            LOGGER.warn("", (Throwable)e);
                        }
                    }
                }
                SSLSetupThread sslSetupThread = new SSLSetupThread(this);
                sslSetupThread.setName("Keystore Registrer");
                sslSetupThread.start();
            }
            catch (Exception e) {
                LOGGER.info("Can't re-init JMXConnectorServer with SSL enabled when register a keystore:" + e.getMessage());
            }
        }
    }

    public void unregister(KeystoreInstance keystore, Map<String, ?> properties) {
        if (this.secured) {
            LOGGER.info("Keystore: {} undeployed. Re-initializing.", (Object)keystore.getName());
            try {
                this.destroy();
            }
            catch (Exception e) {
                LOGGER.info("Can't re-init JMXConnectorServer with SSL enabled when unregister a keystore: " + e.getMessage());
            }
        }
    }

    private static class KarafRMIServerSocketFactory
    implements RMIServerSocketFactory {
        private String rmiServerHost;

        public KarafRMIServerSocketFactory(String rmiServerHost) {
            this.rmiServerHost = rmiServerHost;
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            ServerSocket serverSocket = ServerSocketFactory.getDefault().createServerSocket(port, 50, InetAddress.getByName(this.rmiServerHost));
            return serverSocket;
        }
    }

    private static class KarafSslRMIServerSocketFactory
    implements RMIServerSocketFactory {
        private SSLServerSocketFactory sslServerSocketFactory;
        private boolean clientAuth;
        private String rmiServerHost;

        public KarafSslRMIServerSocketFactory(SSLServerSocketFactory sslServerSocketFactory, boolean clientAuth, String rmiServerHost) {
            this.sslServerSocketFactory = sslServerSocketFactory;
            this.clientAuth = clientAuth;
            this.rmiServerHost = rmiServerHost;
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            SSLServerSocket sslServerSocket = (SSLServerSocket)this.sslServerSocketFactory.createServerSocket(port, 50, InetAddress.getByName(this.rmiServerHost));
            sslServerSocket.setNeedClientAuth(this.clientAuth);
            return sslServerSocket;
        }
    }

    private static enum AuthenticatorType {
        NONE,
        PASSWORD,
        CERTIFICATE;

    }
}

