/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.filter;

import org.apache.qpid.filter.BinaryExpression;
import org.apache.qpid.filter.BooleanExpression;
import org.apache.qpid.filter.FilterableMessage;

public abstract class LogicExpression
extends BinaryExpression
implements BooleanExpression {
    public static BooleanExpression createOR(BooleanExpression lvalue, BooleanExpression rvalue) {
        return new OrExpression(lvalue, rvalue);
    }

    public static BooleanExpression createAND(BooleanExpression lvalue, BooleanExpression rvalue) {
        return new AndExpression(lvalue, rvalue);
    }

    public LogicExpression(BooleanExpression left, BooleanExpression right) {
        super(left, right);
    }

    @Override
    public abstract Object evaluate(FilterableMessage var1);

    @Override
    public boolean matches(FilterableMessage message) {
        Object object = this.evaluate(message);
        return object != null && object == Boolean.TRUE;
    }

    private static class AndExpression
    extends LogicExpression {
        public AndExpression(BooleanExpression lvalue, BooleanExpression rvalue) {
            super(lvalue, rvalue);
        }

        @Override
        public Object evaluate(FilterableMessage message) {
            Boolean lv = (Boolean)this.getLeft().evaluate(message);
            if (lv == null) {
                return null;
            }
            if (!lv.booleanValue()) {
                return Boolean.FALSE;
            }
            Boolean rv = (Boolean)this.getRight().evaluate(message);
            return rv == null ? null : rv;
        }

        @Override
        public String getExpressionSymbol() {
            return "AND";
        }
    }

    private static class OrExpression
    extends LogicExpression {
        public OrExpression(BooleanExpression lvalue, BooleanExpression rvalue) {
            super(lvalue, rvalue);
        }

        @Override
        public Object evaluate(FilterableMessage message) {
            Boolean lv = (Boolean)this.getLeft().evaluate(message);
            if (lv != null && lv.booleanValue()) {
                return Boolean.TRUE;
            }
            Boolean rv = (Boolean)this.getRight().evaluate(message);
            return rv == null ? null : rv;
        }

        @Override
        public String getExpressionSymbol() {
            return "OR";
        }
    }
}

