/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_8_0;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.qpid.AMQException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.QueueDeclareBody;
import org.apache.qpid.framing.amqp_8_0.AMQMethodBody_8_0;
import org.apache.qpid.framing.amqp_8_0.MethodDispatcher_8_0;

public class QueueDeclareBodyImpl
extends AMQMethodBody_8_0
implements QueueDeclareBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        @Override
        public AMQMethodBody newInstance(MarkableDataInput in, long size) throws AMQFrameDecodingException, IOException {
            return new QueueDeclareBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 50;
    public static final int METHOD_ID = 10;
    private final int _ticket;
    private final AMQShortString _queue;
    private final byte _bitfield0;
    private final FieldTable _arguments;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public QueueDeclareBodyImpl(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._ticket = this.readUnsignedShort(buffer);
        this._queue = this.readAMQShortString(buffer);
        this._bitfield0 = this.readBitfield(buffer);
        this._arguments = this.readFieldTable(buffer);
    }

    public QueueDeclareBodyImpl(int ticket, AMQShortString queue, boolean passive, boolean durable, boolean exclusive, boolean autoDelete, boolean nowait, FieldTable arguments) {
        this._ticket = ticket;
        this._queue = queue;
        byte bitfield0 = 0;
        if (passive) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        if (durable) {
            bitfield0 = (byte)(bitfield0 | 2);
        }
        if (exclusive) {
            bitfield0 = (byte)(bitfield0 | 4);
        }
        if (autoDelete) {
            bitfield0 = (byte)(bitfield0 | 8);
        }
        if (nowait) {
            bitfield0 = (byte)(bitfield0 | 0x10);
        }
        this._bitfield0 = bitfield0;
        this._arguments = arguments;
    }

    @Override
    public int getClazz() {
        return 50;
    }

    @Override
    public int getMethod() {
        return 10;
    }

    @Override
    public final int getTicket() {
        return this._ticket;
    }

    @Override
    public final AMQShortString getQueue() {
        return this._queue;
    }

    @Override
    public final boolean getPassive() {
        return (this._bitfield0 & 1) != 0;
    }

    @Override
    public final boolean getDurable() {
        return (this._bitfield0 & 2) != 0;
    }

    @Override
    public final boolean getExclusive() {
        return (this._bitfield0 & 4) != 0;
    }

    @Override
    public final boolean getAutoDelete() {
        return (this._bitfield0 & 8) != 0;
    }

    @Override
    public final boolean getNowait() {
        return (this._bitfield0 & 0x10) != 0;
    }

    @Override
    public final FieldTable getArguments() {
        return this._arguments;
    }

    @Override
    protected int getBodySize() {
        int size = 3;
        size += this.getSizeOf(this._queue);
        return size += this.getSizeOf(this._arguments);
    }

    @Override
    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeUnsignedShort(buffer, this._ticket);
        this.writeAMQShortString(buffer, this._queue);
        this.writeBitfield(buffer, this._bitfield0);
        this.writeFieldTable(buffer, this._arguments);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_8_0)dispatcher).dispatchQueueDeclare(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[QueueDeclareBodyImpl: ");
        buf.append("ticket=");
        buf.append(this.getTicket());
        buf.append(", ");
        buf.append("queue=");
        buf.append(this.getQueue());
        buf.append(", ");
        buf.append("passive=");
        buf.append(this.getPassive());
        buf.append(", ");
        buf.append("durable=");
        buf.append(this.getDurable());
        buf.append(", ");
        buf.append("exclusive=");
        buf.append(this.getExclusive());
        buf.append(", ");
        buf.append("autoDelete=");
        buf.append(this.getAutoDelete());
        buf.append(", ");
        buf.append("nowait=");
        buf.append(this.getNowait());
        buf.append(", ");
        buf.append("arguments=");
        buf.append(this.getArguments());
        buf.append("]");
        return buf.toString();
    }
}

