/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport.network.io;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.qpid.protocol.ProtocolEngine;
import org.apache.qpid.protocol.ProtocolEngineFactory;
import org.apache.qpid.transport.ConnectionSettings;
import org.apache.qpid.transport.NetworkTransportConfiguration;
import org.apache.qpid.transport.Receiver;
import org.apache.qpid.transport.TransportException;
import org.apache.qpid.transport.network.IncomingNetworkTransport;
import org.apache.qpid.transport.network.NetworkConnection;
import org.apache.qpid.transport.network.OutgoingNetworkTransport;
import org.apache.qpid.transport.network.TransportActivity;
import org.apache.qpid.transport.network.io.IdleTimeoutTicker;
import org.apache.qpid.transport.network.io.IoNetworkConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoNetworkTransport
implements OutgoingNetworkTransport,
IncomingNetworkTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoNetworkTransport.class);
    private static final int TIMEOUT = Integer.getInteger("qpid.io_network_transport_timeout", 60000);
    private static final int HANSHAKE_TIMEOUT = Integer.getInteger("qpid.handshake_timeout", 2);
    private Socket _socket;
    private IoNetworkConnection _connection;
    private AcceptingThread _acceptor;

    @Override
    public NetworkConnection connect(ConnectionSettings settings, Receiver<ByteBuffer> delegate, TransportActivity transportActivity) {
        int sendBufferSize = settings.getWriteBufferSize();
        int receiveBufferSize = settings.getReadBufferSize();
        try {
            this._socket = new Socket();
            this._socket.setReuseAddress(true);
            this._socket.setTcpNoDelay(settings.isTcpNodelay());
            this._socket.setSendBufferSize(sendBufferSize);
            this._socket.setReceiveBufferSize(receiveBufferSize);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("SO_RCVBUF : " + this._socket.getReceiveBufferSize());
                LOGGER.debug("SO_SNDBUF : " + this._socket.getSendBufferSize());
                LOGGER.debug("TCP_NODELAY : " + this._socket.getTcpNoDelay());
            }
            InetAddress address = InetAddress.getByName(settings.getHost());
            this._socket.connect(new InetSocketAddress(address, settings.getPort()), settings.getConnectTimeout());
        }
        catch (SocketException e) {
            throw new TransportException("Error connecting to broker", e);
        }
        catch (IOException e) {
            throw new TransportException("Error connecting to broker", e);
        }
        try {
            IdleTimeoutTicker ticker = new IdleTimeoutTicker(transportActivity, TIMEOUT);
            this._connection = new IoNetworkConnection(this._socket, delegate, sendBufferSize, receiveBufferSize, TIMEOUT, ticker);
            ticker.setConnection(this._connection);
            this._connection.start();
        }
        catch (Exception e) {
            try {
                this._socket.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw new TransportException("Error creating network connection", e);
        }
        return this._connection;
    }

    @Override
    public void close() {
        if (this._connection != null) {
            this._connection.close();
        }
        if (this._acceptor != null) {
            this._acceptor.close();
        }
    }

    @Override
    public NetworkConnection getConnection() {
        return this._connection;
    }

    @Override
    public void accept(NetworkTransportConfiguration config, ProtocolEngineFactory factory, SSLContext sslContext) {
        try {
            this._acceptor = new AcceptingThread(config, factory, sslContext);
            this._acceptor.setDaemon(false);
            this._acceptor.start();
        }
        catch (IOException e) {
            throw new TransportException("Failed to start AMQP on port : " + config, e);
        }
    }

    private class AcceptingThread
    extends Thread {
        private volatile boolean _closed = false;
        private NetworkTransportConfiguration _config;
        private ProtocolEngineFactory _factory;
        private SSLContext _sslContext;
        private ServerSocket _serverSocket;
        private int _timeout;

        private AcceptingThread(NetworkTransportConfiguration config, ProtocolEngineFactory factory, SSLContext sslContext) throws IOException {
            this._config = config;
            this._factory = factory;
            this._sslContext = sslContext;
            this._timeout = TIMEOUT;
            InetSocketAddress address = config.getAddress();
            if (sslContext == null) {
                this._serverSocket = new ServerSocket();
            } else {
                SSLServerSocketFactory socketFactory = this._sslContext.getServerSocketFactory();
                this._serverSocket = socketFactory.createServerSocket();
                if (config.needClientAuth()) {
                    ((SSLServerSocket)this._serverSocket).setNeedClientAuth(true);
                } else if (config.wantClientAuth()) {
                    ((SSLServerSocket)this._serverSocket).setWantClientAuth(true);
                }
            }
            this._serverSocket.setReuseAddress(true);
            this._serverSocket.bind(address);
        }

        public void close() {
            LOGGER.debug("Shutting down the Acceptor");
            this._closed = true;
            if (!this._serverSocket.isClosed()) {
                try {
                    this._serverSocket.close();
                }
                catch (IOException e) {
                    throw new TransportException(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block11: {
                block8: while (true) {
                    while (!this._closed) {
                        Socket socket = null;
                        try {
                            socket = this._serverSocket.accept();
                            socket.setTcpNoDelay(this._config.getTcpNoDelay());
                            socket.setSoTimeout(1000 * HANSHAKE_TIMEOUT);
                            Integer sendBufferSize = this._config.getSendBufferSize();
                            Integer receiveBufferSize = this._config.getReceiveBufferSize();
                            socket.setSendBufferSize(sendBufferSize);
                            socket.setReceiveBufferSize(receiveBufferSize);
                            ProtocolEngine engine = this._factory.newProtocolEngine();
                            IdleTimeoutTicker ticker = new IdleTimeoutTicker(engine, TIMEOUT);
                            IoNetworkConnection connection = new IoNetworkConnection(socket, engine, sendBufferSize, receiveBufferSize, this._timeout, ticker);
                            connection.setMaxReadIdle(HANSHAKE_TIMEOUT);
                            ticker.setConnection(connection);
                            engine.setNetworkConnection(connection, connection.getSender());
                            connection.start();
                            continue block8;
                        }
                        catch (RuntimeException e) {
                            LOGGER.error("Error in Acceptor thread on address " + this._config.getAddress(), (Throwable)e);
                            this.closeSocketIfNecessary(socket);
                        }
                        catch (IOException e) {
                            if (this._closed) continue;
                            LOGGER.error("Error in Acceptor thread on address " + this._config.getAddress(), (Throwable)e);
                            this.closeSocketIfNecessary(socket);
                            try {
                                Thread.sleep(1000L);
                                continue block8;
                            }
                            catch (InterruptedException ie) {
                                LOGGER.debug("Stopping acceptor due to interrupt request");
                                this._closed = true;
                            }
                        }
                    }
                    break block11;
                    {
                        continue block8;
                        break;
                    }
                    break;
                }
                finally {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Acceptor exiting, no new connections will be accepted on address " + this._config.getAddress());
                    }
                }
            }
        }

        private void closeSocketIfNecessary(Socket socket) {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    LOGGER.debug("Exception while closing socket", (Throwable)e);
                }
            }
        }
    }
}

