/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.url;

import java.net.URISyntaxException;
import java.util.HashMap;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.url.BindingURL;
import org.apache.qpid.url.BindingURLParser;
import org.apache.qpid.url.URLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQBindingURL
implements BindingURL {
    private static final Logger _logger = LoggerFactory.getLogger(AMQBindingURL.class);
    private String _url;
    private AMQShortString _exchangeClass = AMQShortString.valueOf("direct");
    private AMQShortString _exchangeName = new AMQShortString("");
    private AMQShortString _destinationName = new AMQShortString("");
    private AMQShortString _queueName = new AMQShortString("");
    private AMQShortString[] _bindingKeys = new AMQShortString[0];
    private HashMap<String, String> _options;

    public AMQBindingURL(String url) throws URISyntaxException {
        _logger.debug("Parsing URL: " + url);
        this._url = url;
        this._options = new HashMap();
        this.parseBindingURL();
    }

    private void parseBindingURL() throws URISyntaxException {
        BindingURLParser parser = new BindingURLParser();
        parser.parse(this._url, this);
        _logger.debug("URL Parsed: " + this);
    }

    public void setExchangeClass(String exchangeClass) {
        this.setExchangeClass(new AMQShortString(exchangeClass));
    }

    public void setQueueName(String name) {
        this.setQueueName(new AMQShortString(name));
    }

    public void setDestinationName(String name) {
        this.setDestinationName(new AMQShortString(name));
    }

    public void setExchangeName(String exchangeName) {
        this.setExchangeName(new AMQShortString(exchangeName));
    }

    @Override
    public String getURL() {
        return this._url;
    }

    @Override
    public AMQShortString getExchangeClass() {
        return this._exchangeClass;
    }

    private void setExchangeClass(AMQShortString exchangeClass) {
        this._exchangeClass = exchangeClass;
        if (exchangeClass.equals(AMQShortString.valueOf("topic"))) {
            this.setOption("exclusive", "true");
        }
    }

    @Override
    public AMQShortString getExchangeName() {
        return this._exchangeName;
    }

    private void setExchangeName(AMQShortString name) {
        this._exchangeName = name;
    }

    @Override
    public AMQShortString getDestinationName() {
        return this._destinationName;
    }

    private void setDestinationName(AMQShortString name) {
        this._destinationName = name;
    }

    @Override
    public AMQShortString getQueueName() {
        return this._queueName;
    }

    public void setQueueName(AMQShortString name) {
        this._queueName = name;
    }

    @Override
    public String getOption(String key) {
        return this._options.get(key);
    }

    public void setOption(String key, String value) {
        this._options.put(key, value);
    }

    @Override
    public boolean containsOption(String key) {
        return this._options.containsKey(key);
    }

    @Override
    public AMQShortString getRoutingKey() {
        if (this._exchangeClass.equals(AMQShortString.valueOf("direct"))) {
            if (this.containsOption("routingkey")) {
                return new AMQShortString(this.getOption("routingkey"));
            }
            return this.getQueueName();
        }
        if (this.containsOption("routingkey")) {
            return new AMQShortString(this.getOption("routingkey"));
        }
        return this.getDestinationName();
    }

    @Override
    public AMQShortString[] getBindingKeys() {
        if (this._bindingKeys != null && this._bindingKeys.length > 0) {
            return this._bindingKeys;
        }
        return new AMQShortString[]{this.getRoutingKey()};
    }

    public void setBindingKeys(AMQShortString[] keys) {
        this._bindingKeys = keys;
    }

    public void setRoutingKey(AMQShortString key) {
        this.setOption("routingkey", key.toString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._exchangeClass);
        sb.append("://");
        sb.append(this._exchangeName);
        sb.append('/');
        sb.append(this._destinationName);
        sb.append('/');
        sb.append(this._queueName);
        sb.append(URLHelper.printOptions(this._options));
        if (this.getRoutingKey() == null || this.getRoutingKey().toString().equals("")) {
            if (!sb.toString().contains("?")) {
                sb.append("?");
            } else {
                sb.append("&");
            }
            for (AMQShortString key : this._bindingKeys) {
                sb.append("bindingkey").append("='").append(key.toString()).append("'&");
            }
            return sb.toString().substring(0, sb.toString().length() - 1);
        }
        return sb.toString();
    }
}

