/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.extension.impl.context;

import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.ops4j.pax.cdi.extension.impl.component.ComponentDescriptor;
import org.ops4j.pax.cdi.extension.impl.context.BundleScopeContext;
import org.ops4j.pax.cdi.extension.impl.context.BundleScopeServiceFactory;
import org.ops4j.pax.cdi.extension.impl.context.PrototypeScopeContext;
import org.ops4j.pax.cdi.extension.impl.context.SingletonScopeContext;

public class ServiceFactoryBuilder {
    private BeanManager beanManager;

    public ServiceFactoryBuilder(BeanManager beanManager) {
        this.beanManager = beanManager;
    }

    public <S> Object buildServiceFactory(ComponentDescriptor<S> descriptor) {
        Bean<S> bean = descriptor.getBean();
        Class scope = bean.getScope();
        Context context = this.beanManager.getContext(scope);
        if (context instanceof PrototypeScopeContext) {
            PrototypeScopeContext prototypeScopeContext = (PrototypeScopeContext)context;
            return this.buildPrototypeScopeServiceFactory(prototypeScopeContext, bean);
        }
        if (context instanceof BundleScopeContext) {
            BundleScopeContext bundleScopeContext = (BundleScopeContext)context;
            return new BundleScopeServiceFactory<S>(bundleScopeContext, bean);
        }
        if (context instanceof SingletonScopeContext) {
            SingletonScopeContext singletonContext = (SingletonScopeContext)context;
            CreationalContext cc = singletonContext.getCreationalContext();
            return singletonContext.get(bean, cc);
        }
        throw new IllegalStateException(bean.getBeanClass() + " does not have an OSGi compatible scope");
    }

    protected <S> Object buildPrototypeScopeServiceFactory(PrototypeScopeContext context, Bean<S> bean) {
        throw new IllegalStateException("prototype scope not supported");
    }
}

