/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.bean.ProxyHelper;
import org.apache.camel.util.ObjectHelper;

public final class ProxyBuilder {
    private final CamelContext camelContext;
    private Endpoint endpoint;

    public ProxyBuilder(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public ProxyBuilder endpoint(String url) {
        this.endpoint = this.camelContext.getEndpoint(url);
        return this;
    }

    public ProxyBuilder endpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public <T> T build(Class<T> interfaceClass) throws Exception {
        return this.build(new Class[]{interfaceClass});
    }

    public <T> T build(Class<T> ... interfaceClasses) throws Exception {
        ObjectHelper.notNull(this.endpoint, "endpoint");
        return ProxyHelper.createProxy(this.endpoint, interfaceClasses);
    }
}

