/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.idempotent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.processor.idempotent.IdempotentOnCompletion;
import org.apache.camel.processor.idempotent.NoMessageIdException;
import org.apache.camel.spi.ExchangeIdempotentRepository;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorConverterHelper;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdempotentConsumer
extends ServiceSupport
implements AsyncProcessor,
Navigate<Processor>,
IdAware {
    private static final Logger LOG = LoggerFactory.getLogger(IdempotentConsumer.class);
    private String id;
    private final Expression messageIdExpression;
    private final AsyncProcessor processor;
    private final IdempotentRepository<String> idempotentRepository;
    private final boolean eager;
    private final boolean skipDuplicate;
    private final boolean removeOnFailure;
    private final AtomicLong duplicateMessageCount = new AtomicLong();

    public IdempotentConsumer(Expression messageIdExpression, IdempotentRepository<String> idempotentRepository, boolean eager, boolean skipDuplicate, boolean removeOnFailure, Processor processor) {
        this.messageIdExpression = messageIdExpression;
        this.idempotentRepository = idempotentRepository;
        this.eager = eager;
        this.skipDuplicate = skipDuplicate;
        this.removeOnFailure = removeOnFailure;
        this.processor = AsyncProcessorConverterHelper.convert(processor);
    }

    public String toString() {
        return "IdempotentConsumer[" + this.messageIdExpression + " -> " + this.processor + "]";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        boolean newKey;
        String messageId = this.messageIdExpression.evaluate(exchange, String.class);
        if (messageId == null) {
            exchange.setException(new NoMessageIdException(exchange, this.messageIdExpression));
            callback.done(true);
            return true;
        }
        if (this.eager) {
            newKey = this.idempotentRepository instanceof ExchangeIdempotentRepository ? ((ExchangeIdempotentRepository)this.idempotentRepository).add(exchange, messageId) : this.idempotentRepository.add(messageId);
        } else if (this.idempotentRepository instanceof ExchangeIdempotentRepository) {
            newKey = ((ExchangeIdempotentRepository)this.idempotentRepository).contains(exchange, messageId);
        } else {
            boolean bl = newKey = !this.idempotentRepository.contains(messageId);
        }
        if (!newKey) {
            exchange.setProperty("CamelDuplicateMessage", Boolean.TRUE);
            this.onDuplicate(exchange, messageId);
            if (this.skipDuplicate) {
                LOG.debug("Ignoring duplicate message with id: {} for exchange: {}", (Object)messageId, (Object)exchange);
                callback.done(true);
                return true;
            }
        }
        exchange.addOnCompletion(new IdempotentOnCompletion(this.idempotentRepository, messageId, this.eager, this.removeOnFailure));
        return this.processor.process(exchange, callback);
    }

    @Override
    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>(1);
        answer.add(this.processor);
        return answer;
    }

    @Override
    public boolean hasNext() {
        return this.processor != null;
    }

    public Expression getMessageIdExpression() {
        return this.messageIdExpression;
    }

    public IdempotentRepository<String> getIdempotentRepository() {
        return this.idempotentRepository;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public long getDuplicateMessageCount() {
        return this.duplicateMessageCount.get();
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.processor);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.processor);
    }

    public void resetDuplicateMessageCount() {
        this.duplicateMessageCount.set(0L);
    }

    private void onDuplicate(Exchange exchange, String messageId) {
        this.duplicateMessageCount.incrementAndGet();
        this.onDuplicateMessage(exchange, messageId);
    }

    protected void onDuplicateMessage(Exchange exchange, String messageId) {
    }
}

