/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.toolbox;

import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.AggregationStrategyBeanAdapter;
import org.apache.camel.processor.aggregate.GroupedExchangeAggregationStrategy;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.apache.camel.processor.aggregate.UseOriginalAggregationStrategy;
import org.apache.camel.util.toolbox.FlexibleAggregationStrategy;

public final class AggregationStrategies {
    private AggregationStrategies() {
    }

    public static <T> FlexibleAggregationStrategy<T> flexible(Class<T> type) {
        return new FlexibleAggregationStrategy<T>(type);
    }

    public static FlexibleAggregationStrategy<Object> flexible() {
        return new FlexibleAggregationStrategy<Object>();
    }

    public static AggregationStrategy useLatest() {
        return new UseLatestAggregationStrategy();
    }

    public static AggregationStrategy useOriginal() {
        return new UseOriginalAggregationStrategy();
    }

    public static AggregationStrategy groupedExchange() {
        return new GroupedExchangeAggregationStrategy();
    }

    public static AggregationStrategy bean(Object bean) {
        return new AggregationStrategyBeanAdapter(bean);
    }

    public static AggregationStrategy bean(Object bean, String methodName) {
        return new AggregationStrategyBeanAdapter(bean, methodName);
    }

    public static AggregationStrategy beanAllowNull(Object bean, String methodName) {
        AggregationStrategyBeanAdapter adapter = new AggregationStrategyBeanAdapter(bean, methodName);
        adapter.setAllowNullOldExchange(true);
        adapter.setAllowNullNewExchange(true);
        return adapter;
    }

    public static AggregationStrategy bean(Class<?> type) {
        return new AggregationStrategyBeanAdapter(type);
    }

    public static AggregationStrategy bean(Class<?> type, String methodName) {
        return new AggregationStrategyBeanAdapter(type, methodName);
    }

    public static AggregationStrategy beanAllowNull(Class<?> type, String methodName) {
        AggregationStrategyBeanAdapter adapter = new AggregationStrategyBeanAdapter(type, methodName);
        adapter.setAllowNullOldExchange(true);
        adapter.setAllowNullNewExchange(true);
        return adapter;
    }
}

