/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.engine.BpelProcessDatabase;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.dao.bpel.BpelDAOConnection;
import org.apache.ode.dao.bpel.BpelDAOConnectionFactory;

public class BpelDatabase {
    static Log __log = LogFactory.getLog(BpelDatabase.class);
    protected BpelDAOConnectionFactory _sscf;
    protected Scheduler _scheduler;

    BpelDatabase(BpelDAOConnectionFactory sscf, Scheduler scheduler) {
        if (sscf == null) {
            throw new NullPointerException("sscf is null!");
        }
        if (scheduler == null) {
            throw new NullPointerException("scheduler is null!");
        }
        this._sscf = sscf;
        this._scheduler = scheduler;
    }

    BpelDAOConnection getConnection() {
        return this._sscf.getConnection();
    }

    BpelProcessDatabase getProcessDb(QName pid) {
        return new BpelProcessDatabase(this._sscf, this._scheduler, pid);
    }

    public <T> T exec(final Callable<T> callable) throws Exception {
        return this._scheduler.execTransaction(new java.util.concurrent.Callable<T>(){

            @Override
            public T call() throws Exception {
                return callable.run(BpelDatabase.this._sscf.getConnection());
            }
        });
    }

    public static interface Callable<T> {
        public T run(BpelDAOConnection var1) throws Exception;
    }
}

