/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.Set;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.engine.BpelEngineImpl;
import org.apache.ode.bpel.engine.MessageImpl;
import org.apache.ode.bpel.engine.Messages;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.dao.bpel.MessageDAO;
import org.apache.ode.dao.bpel.MessageExchangeDAO;
import org.apache.ode.utils.msg.MessageBundle;
import org.w3c.dom.Element;

abstract class MessageExchangeImpl
implements MessageExchange {
    private static final Log __log = LogFactory.getLog(MessageExchangeImpl.class);
    protected static final Messages __msgs = MessageBundle.getMessages(Messages.class);
    protected Long _iid;
    protected PortType _portType;
    protected Operation _operation;
    protected final BpelEngineImpl _engine;
    protected EndpointReference _epr;
    protected MessageExchangeDAO _dao;

    MessageExchangeImpl(BpelEngineImpl engine, MessageExchangeDAO dao, MessageExchange.MessageExchangePattern pattern, String opname, EndpointReference epr) {
        this._engine = engine;
        this._dao = dao;
        this._epr = epr;
        this.getDAO().setPattern(pattern.toString());
        this.getDAO().setOperation(opname);
        if (epr != null) {
            this.getDAO().setEPR(epr.toXML().getDocumentElement());
        }
    }

    public MessageExchangeImpl(BpelEngineImpl engine, MessageExchangeDAO dao) {
        this._engine = engine;
        this._dao = dao;
    }

    @Override
    public String getMessageExchangeId() throws BpelEngineException {
        return this.getDAO().getMessageExchangeId();
    }

    @Override
    public String getOperationName() throws BpelEngineException {
        return this.getDAO().getOperation();
    }

    @Override
    public MessageExchange.MessageExchangePattern getMessageExchangePattern() {
        return MessageExchange.MessageExchangePattern.valueOf(this.getDAO().getPattern());
    }

    @Override
    public boolean isTransactionPropagated() throws BpelEngineException {
        return this.getDAO().getPropagateTransactionFlag();
    }

    @Override
    public Message getResponse() {
        if (this.getDAO().getResponse() != null) {
            return new MessageImpl(this.getDAO().getResponse());
        }
        return null;
    }

    @Override
    public QName getFault() {
        return this.getDAO().getFault();
    }

    @Override
    public Message getFaultResponse() {
        return this.getResponse();
    }

    @Override
    public String getFaultExplanation() {
        return this.getDAO().getFaultExplanation();
    }

    public MessageExchange.MessageExchangePattern getPattern() {
        return MessageExchange.MessageExchangePattern.valueOf(this.getDAO().getPattern());
    }

    @Override
    public MessageExchange.Status getStatus() {
        return MessageExchange.Status.valueOf(this.getDAO().getStatus());
    }

    @Override
    public Message getRequest() {
        return new MessageImpl(this.getDAO().getRequest());
    }

    @Override
    public Operation getOperation() {
        return this._operation;
    }

    @Override
    public PortType getPortType() {
        return this._portType;
    }

    void setPattern(MessageExchange.MessageExchangePattern pattern) {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)("Mex[" + this.getMessageExchangeId() + "].setPattern(" + (Object)((Object)pattern) + ")"));
        }
        this.getDAO().setPattern(pattern.toString());
    }

    void setPortOp(PortType portType, Operation operation) {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)("Mex[" + this.getMessageExchangeId() + "].setPortOp(...)"));
        }
        this._portType = portType;
        this._operation = operation;
    }

    public MessageExchangeDAO getDAO() {
        return this._dao;
    }

    void setFault(QName faultType, Message outputFaultMessage) throws BpelEngineException {
        this.setStatus(MessageExchange.Status.FAULT);
        this.getDAO().setFault(faultType);
        this.getDAO().setResponse(((MessageImpl)outputFaultMessage)._dao);
        this.responseReceived();
    }

    void setFaultExplanation(String explanation) {
        this.getDAO().setFaultExplanation(explanation);
    }

    void setResponse(Message outputMessage) throws BpelEngineException {
        if (this.getStatus() != MessageExchange.Status.REQUEST && this.getStatus() != MessageExchange.Status.ASYNC) {
            throw new IllegalStateException("Not in REQUEST state!");
        }
        this.setStatus(MessageExchange.Status.RESPONSE);
        this.getDAO().setFault(null);
        this.getDAO().setResponse(((MessageImpl)outputMessage)._dao);
        this.responseReceived();
    }

    void setFailure(MessageExchange.FailureType type, String reason, Element details) throws BpelEngineException {
        this.setStatus(MessageExchange.Status.FAILURE);
        this.getDAO().setFaultExplanation(reason);
    }

    void setStatus(MessageExchange.Status status) {
        this.getDAO().setStatus(status.toString());
    }

    @Override
    public Message createMessage(QName msgType) {
        MessageDAO mdao = this.getDAO().createMessage(msgType);
        return new MessageImpl(mdao);
    }

    public void setEndpointReference(EndpointReference ref) {
        this._epr = ref;
        if (ref != null) {
            this.getDAO().setEPR(ref.toXML().getDocumentElement());
        }
    }

    @Override
    public EndpointReference getEndpointReference() throws BpelEngineException {
        if (this._epr != null) {
            return this._epr;
        }
        if (this.getDAO().getEPR() == null) {
            return null;
        }
        this._epr = this._engine._contexts.eprContext.resolveEndpointReference(this.getDAO().getEPR());
        return this._epr;
    }

    QName getServiceName() {
        return this.getDAO().getCallee();
    }

    @Override
    public String getProperty(String key) {
        String val = this.getDAO().getProperty(key);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("GET MEX property " + key + " = " + val));
        }
        return val;
    }

    @Override
    public void setProperty(String key, String value) {
        this.getDAO().setProperty(key, value);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("SET MEX property " + key + " = " + value));
        }
    }

    @Override
    public Set<String> getPropertyNames() {
        return this.getDAO().getPropertyNames();
    }

    public int getSubscriberCount() {
        return this.getDAO().getSubscriberCount();
    }

    public void setSubscriberCount(int subscriberCount) {
        this.getDAO().setSubscriberCount(subscriberCount);
    }

    @Override
    public void release() {
        __log.debug((Object)("Releasing mex " + this.getMessageExchangeId()));
        this._dao.release(true);
        this._dao = null;
    }

    public String toString() {
        return "MEX[" + this.getDAO().getMessageExchangeId() + "]";
    }

    protected void responseReceived() {
    }
}

