/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.epr;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.epr.MutableEndpoint;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.Namespaces;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSAEndpoint
implements MutableEndpoint {
    private static final Log __log = LogFactory.getLog(WSAEndpoint.class);
    private Element _eprElmt;

    public WSAEndpoint() {
    }

    public WSAEndpoint(WSAEndpoint prototype) {
        this._eprElmt = (Element)DOMUtils.newDocument().importNode(prototype._eprElmt, true);
    }

    public WSAEndpoint(Map map) {
        this();
        this.fromMap(map);
    }

    public String getSessionId() {
        NodeList idNodes = this._eprElmt.getElementsByTagNameNS(Namespaces.ODE_SESSION_NS, "session");
        if (idNodes.getLength() > 0) {
            return idNodes.item(0).getTextContent();
        }
        idNodes = this._eprElmt.getElementsByTagNameNS(Namespaces.INTALIO_SESSION_NS, "session");
        if (idNodes.getLength() > 0) {
            return idNodes.item(0).getTextContent();
        }
        return null;
    }

    public void setSessionId(String sessionId) {
        Element sessElmt;
        NodeList idList = this._eprElmt.getElementsByTagNameNS(Namespaces.ODE_SESSION_NS, "session");
        if (idList.getLength() > 0) {
            idList.item(0).setTextContent(sessionId);
        } else {
            sessElmt = this._eprElmt.getOwnerDocument().createElementNS(Namespaces.ODE_SESSION_NS, "session");
            sessElmt.setTextContent(sessionId);
            this._eprElmt.appendChild(sessElmt);
        }
        idList = this._eprElmt.getElementsByTagNameNS(Namespaces.INTALIO_SESSION_NS, "session");
        if (idList.getLength() > 0) {
            idList.item(0).setTextContent(sessionId);
        } else {
            sessElmt = this._eprElmt.getOwnerDocument().createElementNS(Namespaces.INTALIO_SESSION_NS, "session");
            sessElmt.setTextContent(sessionId);
            this._eprElmt.appendChild(sessElmt);
        }
    }

    @Override
    public String getUrl() {
        return this._eprElmt.getElementsByTagNameNS(Namespaces.WS_ADDRESSING_NS, "Address").item(0).getTextContent().trim();
    }

    public void setUrl(String url) {
        NodeList addrList = this._eprElmt.getElementsByTagNameNS(Namespaces.WS_ADDRESSING_NS, "Address");
        if (addrList.getLength() > 0) {
            addrList.item(0).setTextContent(url);
        } else {
            Element addrElmt = this._eprElmt.getOwnerDocument().createElementNS(Namespaces.WS_ADDRESSING_NS, "Address");
            addrElmt.setTextContent(url);
            this._eprElmt.appendChild(addrElmt);
        }
    }

    public QName getServiceName() {
        NodeList metadataList = this._eprElmt.getElementsByTagNameNS(Namespaces.WS_ADDRESSING_NS, "Metadata");
        if (metadataList.getLength() > 0) {
            Element metadata = (Element)metadataList.item(0);
            Element service = DOMUtils.getFirstChildElement(metadata);
            String serviceTextQName = service.getTextContent();
            int twoDotsIdx = serviceTextQName.indexOf(":");
            String prefix = serviceTextQName.substring(0, twoDotsIdx);
            String serviceNS = this._eprElmt.getOwnerDocument().lookupNamespaceURI(prefix);
            if (serviceNS == null) {
                serviceNS = service.getAttribute("xmlns:" + prefix);
            }
            if (serviceNS == null) {
                __log.warn((Object)"Couldn't find an appropriate namespace for service!");
            }
            QName result = new QName(serviceNS, serviceTextQName.substring(twoDotsIdx + 1, serviceTextQName.length()));
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Got service name from WSAEndpoint: " + result));
            }
            return result;
        }
        return null;
    }

    public String getPortName() {
        NodeList metadataList = this._eprElmt.getElementsByTagNameNS(Namespaces.WS_ADDRESSING_NS, "Metadata");
        if (metadataList.getLength() > 0) {
            Element metadata = (Element)metadataList.item(0);
            Element service = DOMUtils.getFirstChildElement(metadata);
            return service.getAttribute("EndpointName");
        }
        return null;
    }

    @Override
    public boolean accept(Node node) {
        if (node.getNodeType() == 1) {
            Element elmt = (Element)node;
            if (elmt.getLocalName().equals(SERVICE_REF_QNAME.getLocalPart()) && elmt.getNamespaceURI().equals(SERVICE_REF_QNAME.getNamespaceURI())) {
                elmt = DOMUtils.getFirstChildElement(elmt);
            }
            if (elmt != null && elmt.getLocalName().equals("EndpointReference") && elmt.getNamespaceURI().equals(Namespaces.WS_ADDRESSING_NS)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void set(Node node) {
        this._eprElmt = node.getNamespaceURI().equals(SERVICE_REF_QNAME.getNamespaceURI()) ? DOMUtils.getFirstChildElement((Element)node) : (Element)node;
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Setting a WSAEndpoint value: " + DOMUtils.domToString(this._eprElmt)));
        }
    }

    @Override
    public Document toXML() {
        Document doc = DOMUtils.newDocument();
        Element serviceRef = doc.createElementNS(SERVICE_REF_QNAME.getNamespaceURI(), SERVICE_REF_QNAME.getLocalPart());
        doc.appendChild(serviceRef);
        serviceRef.appendChild(doc.importNode(this._eprElmt, true));
        return this._eprElmt.getOwnerDocument();
    }

    @Override
    public Map toMap() {
        NodeList metadataList;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("address", this.getUrl());
        String sid = this.getSessionId();
        if (sid != null) {
            result.put("session", sid);
        }
        if ((metadataList = this._eprElmt.getElementsByTagNameNS(Namespaces.WS_ADDRESSING_NS, "Metadata")).getLength() > 0) {
            Element metadata = (Element)metadataList.item(0);
            Element service = DOMUtils.getFirstChildElement(metadata);
            String serviceTextQName = service.getTextContent();
            int twoDotsIdx = serviceTextQName.indexOf(":");
            String prefix = serviceTextQName.substring(0, twoDotsIdx);
            String serviceNS = null;
            try {
                serviceNS = this._eprElmt.getOwnerDocument().lookupNamespaceURI(prefix);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (serviceNS == null) {
                serviceNS = service.getAttribute("xmlns:" + prefix);
            }
            result.put("service", new QName(serviceNS, serviceTextQName.substring(twoDotsIdx + 1, serviceTextQName.length())));
            result.put("port", service.getAttribute("EndpointName"));
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Filled transfo map with service: " + result.get("service")));
                __log.debug((Object)("Filled transfo map with port: " + result.get("port")));
            }
        }
        return result;
    }

    @Override
    public void fromMap(Map eprMap) {
        Document doc = DOMUtils.newDocument();
        Element serviceRef = doc.createElementNS(SERVICE_REF_QNAME.getNamespaceURI(), SERVICE_REF_QNAME.getLocalPart());
        doc.appendChild(serviceRef);
        this._eprElmt = doc.createElementNS(Namespaces.WS_ADDRESSING_NS, "EndpointReference");
        serviceRef.appendChild(this._eprElmt);
        Element addrElmt = doc.createElementNS(Namespaces.WS_ADDRESSING_NS, "Address");
        addrElmt.setTextContent((String)eprMap.get("address"));
        if (eprMap.get("session") != null) {
            Element sessElmt = doc.createElementNS(Namespaces.ODE_SESSION_NS, "session");
            sessElmt.setTextContent((String)eprMap.get("session"));
            this._eprElmt.appendChild(sessElmt);
            sessElmt = doc.createElementNS(Namespaces.INTALIO_SESSION_NS, "session");
            sessElmt.setTextContent((String)eprMap.get("session"));
            this._eprElmt.appendChild(sessElmt);
        }
        if (eprMap.get("service") != null) {
            Element metadataElmt = doc.createElementNS(Namespaces.WS_ADDRESSING_NS, "Metadata");
            this._eprElmt.appendChild(metadataElmt);
            Element serviceElmt = doc.createElementNS(Namespaces.WS_ADDRESSING_WSDL_NS, "ServiceName");
            metadataElmt.appendChild(serviceElmt);
            QName serviceQName = (QName)eprMap.get("service");
            serviceElmt.setAttribute("xmlns:servicens", serviceQName.getNamespaceURI());
            serviceElmt.setTextContent("servicens:" + serviceQName.getLocalPart());
            serviceElmt.setAttribute("EndpointName", (String)eprMap.get("port"));
        }
        this._eprElmt.appendChild(addrElmt);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Constructed a new WSAEndpoint: " + DOMUtils.domToString(this._eprElmt)));
        }
    }
}

