/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.il.txutil;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.il.config.OdeConfigProperties;
import org.apache.ode.il.txutil.TransactionConfigException;

public class TxManager {
    private static final Log __log = LogFactory.getLog(TxManager.class);
    private OdeConfigProperties _odeConfig;
    private boolean _debugTxn = false;

    public TxManager(OdeConfigProperties props) {
        if (props == null) {
            throw new NullPointerException("Must provide a configuration.");
        }
        this._odeConfig = props;
        this._debugTxn = Boolean.valueOf(this._odeConfig.getProperty("tx.debug", "false"));
    }

    public TransactionManager createTransactionManager() throws TransactionConfigException {
        String txFactoryName = this._odeConfig.getTxFactoryClass();
        __log.debug((Object)("Initializing transaction manager using " + txFactoryName));
        try {
            Class<?> txFactClass = Class.forName(txFactoryName);
            Object txFact = txFactClass.newInstance();
            TransactionManager txMgr = (TransactionManager)txFactClass.getMethod("getTransactionManager", null).invoke(txFact, new Object[0]);
            if (__log.isDebugEnabled() && this._debugTxn) {
                txMgr = new DebugTxMgr(txMgr);
            }
            return txMgr;
        }
        catch (Exception e) {
            __log.fatal((Object)("Couldn't initialize a transaction manager with factory: " + txFactoryName), (Throwable)e);
            throw new TransactionConfigException("Couldn't initialize a transaction manager with factory: " + txFactoryName, e);
        }
    }

    public static class DebugTx
    implements Transaction {
        private Transaction _tx;

        public DebugTx(Transaction tx) {
            this._tx = tx;
        }

        public void commit() throws HeuristicMixedException, HeuristicRollbackException, RollbackException, SecurityException, SystemException {
            __log.debug((Object)"Tx commit");
            this._tx.commit();
        }

        public boolean delistResource(XAResource xaResource, int i) throws IllegalStateException, SystemException {
            return this._tx.delistResource(xaResource, i);
        }

        public boolean enlistResource(XAResource xaResource) throws IllegalStateException, RollbackException, SystemException {
            return this._tx.enlistResource(xaResource);
        }

        public int getStatus() throws SystemException {
            return this._tx.getStatus();
        }

        public void registerSynchronization(Synchronization synchronization) throws IllegalStateException, RollbackException, SystemException {
            __log.debug((Object)("Synchronization registration on " + synchronization.getClass().getName()));
            this._tx.registerSynchronization(synchronization);
        }

        public void rollback() throws IllegalStateException, SystemException {
            __log.debug((Object)"Tx rollback");
            this._tx.rollback();
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            __log.debug((Object)"Tx set rollback");
            this._tx.setRollbackOnly();
        }
    }

    public static class DebugTxMgr
    implements TransactionManager {
        protected TransactionManager _tm;

        public DebugTxMgr(TransactionManager tm) {
            this._tm = tm;
        }

        public void begin() throws NotSupportedException, SystemException {
            __log.debug((Object)"Txm begin");
            this._tm.begin();
        }

        public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
            __log.debug((Object)"Txm commit");
            for (StackTraceElement traceElement : Thread.currentThread().getStackTrace()) {
                __log.debug((Object)traceElement.toString());
            }
            this._tm.commit();
        }

        public int getStatus() throws SystemException {
            __log.debug((Object)"Txm status");
            return this._tm.getStatus();
        }

        public Transaction getTransaction() throws SystemException {
            Transaction tx = this._tm.getTransaction();
            __log.debug((Object)("Txm get tx " + tx));
            return tx == null ? null : new DebugTx(tx);
        }

        public void resume(Transaction transaction) throws IllegalStateException, InvalidTransactionException, SystemException {
            __log.debug((Object)"Txm resume");
            this._tm.resume(transaction);
        }

        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            __log.debug((Object)"Txm rollback");
            this._tm.rollback();
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            __log.debug((Object)"Txm set rollback");
            this._tm.setRollbackOnly();
        }

        public void setTransactionTimeout(int i) throws SystemException {
            __log.debug((Object)("Txm set tiemout " + i));
            this._tm.setTransactionTimeout(i);
        }

        public Transaction suspend() throws SystemException {
            __log.debug((Object)"Txm suspend");
            return this._tm.suspend();
        }
    }
}

