/*
 * Decompiled with CFR 0.152.
 */
package org.jledit.command.editor;

import org.jledit.ConsoleEditor;
import org.jledit.command.editor.AbstractUndoableCommand;
import org.jledit.command.editor.Position;
import org.jledit.utils.ClipboardUtils;

public class PasteCommand
extends AbstractUndoableCommand {
    private final String clipboardContent;
    private final Position position;

    public PasteCommand(ConsoleEditor editor) {
        this(editor, Position.CURRENT);
    }

    public PasteCommand(ConsoleEditor editor, Position position) {
        super(editor);
        this.position = position;
        this.clipboardContent = ClipboardUtils.getContnet();
    }

    @Override
    public void doExecute() {
        if (!this.getEditor().isReadOnly()) {
            this.getEditor().setDirty(true);
            if (!this.clipboardContent.isEmpty()) {
                switch (this.position) {
                    case CURRENT: {
                        this.getEditor().put(this.clipboardContent);
                        break;
                    }
                    case NEXT_LINE: {
                        this.getEditor().moveToEndOfLine();
                        this.getEditor().newLine();
                        this.getEditor().put(this.clipboardContent);
                        break;
                    }
                    case PREVIOUS_LINE: {
                        this.getEditor().moveToStartOfLine();
                        this.getEditor().newLine();
                        this.getEditor().moveUp(1);
                        this.getEditor().put(this.clipboardContent);
                    }
                }
            }
        }
    }

    @Override
    public void undo() {
        if (!this.getEditor().isReadOnly()) {
            switch (this.position) {
                case NEXT_LINE: {
                    this.getEditor().move(this.getBeforeLine(), this.getBeforeColumn());
                    this.getEditor().mergeLine();
                }
                case CURRENT: {
                    this.getEditor().move(this.getBeforeLine(), this.getBeforeColumn());
                    for (int i = 0; i < this.clipboardContent.length(); ++i) {
                        this.getEditor().delete();
                    }
                    break;
                }
                case PREVIOUS_LINE: {
                    this.getEditor().move(this.getBeforeLine() - 1, this.getBeforeColumn());
                    this.getEditor().mergeLine();
                    this.getEditor().move(this.getBeforeLine(), this.getBeforeColumn());
                    for (int i = 0; i < this.clipboardContent.length(); ++i) {
                        this.getEditor().delete();
                    }
                    break;
                }
            }
        }
    }
}

