/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.extender.impl;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.ops4j.pax.cdi.extender.impl.CdiContainerWrapper;
import org.ops4j.pax.cdi.spi.BeanBundles;
import org.ops4j.pax.cdi.spi.CdiContainer;
import org.ops4j.pax.cdi.spi.CdiContainerFactory;
import org.ops4j.pax.cdi.spi.CdiContainerListener;
import org.ops4j.pax.cdi.spi.CdiContainerType;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdiExtender
implements BundleTrackerCustomizer<CdiContainerWrapper> {
    private static Logger log = LoggerFactory.getLogger(CdiExtender.class);
    private BundleContext context;
    private BundleTracker<CdiContainerWrapper> bundleWatcher;
    private CdiContainerFactory factory;
    private CdiContainerListener webAdapter;
    private Map<Long, Bundle> webBundles = new HashMap<Long, Bundle>();

    public void activate(BundleContext ctx) {
        this.context = ctx;
        if (this.webAdapter != null) {
            this.handleWebBundles();
        }
        log.info("starting CDI extender {}", (Object)this.context.getBundle().getSymbolicName());
        this.bundleWatcher = new BundleTracker(this.context, 32, (BundleTrackerCustomizer)this);
        this.bundleWatcher.open();
    }

    public void deactivate(BundleContext ctx) {
        log.info("stopping CDI extender {}", (Object)this.context.getBundle().getSymbolicName());
        this.bundleWatcher.close();
    }

    public CdiContainerWrapper addingBundle(Bundle bundle, BundleEvent event) {
        boolean wired = false;
        List wires = ((BundleWiring)bundle.adapt(BundleWiring.class)).getRequiredWires("osgi.extender");
        if (wires != null) {
            for (BundleWire wire : wires) {
                if (wire.getProviderWiring().getBundle() != this.context.getBundle()) continue;
                wired = true;
                break;
            }
        }
        if (wired) {
            log.debug("found bean bundle: {}", (Object)bundle.getSymbolicName());
            return this.createContainer(bundle);
        }
        log.trace("not a bean bundle: {}", (Object)bundle.getSymbolicName());
        return null;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, CdiContainerWrapper object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedBundle(Bundle bundle, BundleEvent event, CdiContainerWrapper wrapper) {
        CdiContainer container = wrapper.getCdiContainer();
        if (container != null) {
            CdiContainer cdiContainer = container;
            synchronized (cdiContainer) {
                container.stop();
            }
        }
        this.factory.removeContainer(bundle);
    }

    private CdiContainerWrapper createContainer(Bundle bundle) {
        Dictionary headers = bundle.getHeaders();
        String contextPath = (String)headers.get("Web-ContextPath");
        CdiContainerType containerType = contextPath == null ? CdiContainerType.STANDALONE : CdiContainerType.WEB;
        CdiContainerWrapper wrapper = new CdiContainerWrapper(bundle);
        CdiContainer container = null;
        if (containerType == CdiContainerType.WEB) {
            if (this.webAdapter == null) {
                this.webBundles.put(bundle.getBundleId(), bundle);
            } else {
                container = this.doCreateContainer(bundle, containerType);
            }
        } else {
            container = this.doCreateContainer(bundle, containerType);
            container.start(null);
        }
        wrapper.setCdiContainer(container);
        return wrapper;
    }

    private CdiContainer doCreateContainer(Bundle bundle, CdiContainerType containerType) {
        HashSet extensions = new HashSet();
        BeanBundles.findExtensions((Bundle)bundle, extensions);
        log.info("creating CDI container for bean bundle {} with extension bundles {}", (Object)bundle, extensions);
        return this.factory.createContainer(bundle, extensions, containerType);
    }

    public void setWebAdapter(CdiContainerListener listener) {
        this.webAdapter = listener;
        if (this.context != null) {
            this.handleWebBundles();
        }
    }

    private void handleWebBundles() {
        this.factory.addListener(this.webAdapter);
        for (Bundle bundle : this.webBundles.values()) {
            this.doCreateContainer(bundle, CdiContainerType.WEB);
        }
        this.webBundles.clear();
    }

    public void unsetWebAdapter(CdiContainerListener listener) {
        if (this.factory != null) {
            this.factory.removeListener(listener);
        }
        this.webAdapter = null;
    }

    public void setCdiContainerFactory(CdiContainerFactory cdiContainerFactory) {
        this.factory = cdiContainerFactory;
    }
}

