/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.ldap;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.karaf.jaas.modules.ldap.ExpiringMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPCache {
    public static final String CACHE_TIME_TO_LIVE = "cache.timeToLive";
    public static final int DEFAULT_TIME_TO_LIVE = 3600;
    private static final ConcurrentMap<Map<String, ?>, LDAPCache> CACHES = new ConcurrentHashMap();
    private final int timeToLive;
    private final ExpiringMap<String, String[]> userDnAndNamespace;
    private final ExpiringMap<String, String[]> userRoles;

    public static void clear() {
        CACHES.clear();
    }

    public static LDAPCache getCache(Map<String, ?> options) {
        LDAPCache cache = (LDAPCache)CACHES.get(options);
        if (cache == null) {
            CACHES.putIfAbsent(options, new LDAPCache(options));
            cache = (LDAPCache)CACHES.get(options);
        }
        return cache;
    }

    public LDAPCache(Map<String, ?> options) {
        this.timeToLive = options.containsKey(CACHE_TIME_TO_LIVE) ? Integer.parseInt(options.get(CACHE_TIME_TO_LIVE).toString()) : 3600;
        this.userDnAndNamespace = new ExpiringMap(this.timeToLive);
        this.userRoles = new ExpiringMap(this.timeToLive);
    }

    public String[] getUserDnAndNamespace(String user, Callable<String[]> callable) throws Exception {
        String[] result = this.userDnAndNamespace.get(user);
        if (result == null && (result = callable.call()) != null) {
            this.userDnAndNamespace.put(user, result);
        }
        return result;
    }

    public String[] getUserRoles(String userDN, Callable<String[]> callable) throws Exception {
        String[] result = this.userRoles.get(userDN);
        if (result == null && (result = callable.call()) != null) {
            this.userRoles.put(userDN, result);
        }
        return result;
    }
}

