/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v24.group.RPA_I08_AUTHORIZATION;
import ca.uhn.hl7v2.model.v24.group.RPA_I08_INSURANCE;
import ca.uhn.hl7v2.model.v24.group.RPA_I08_OBSERVATION;
import ca.uhn.hl7v2.model.v24.group.RPA_I08_PROCEDURE;
import ca.uhn.hl7v2.model.v24.group.RPA_I08_PROVIDER;
import ca.uhn.hl7v2.model.v24.group.RPA_I08_VISIT;
import ca.uhn.hl7v2.model.v24.segment.ACC;
import ca.uhn.hl7v2.model.v24.segment.AL1;
import ca.uhn.hl7v2.model.v24.segment.DG1;
import ca.uhn.hl7v2.model.v24.segment.DRG;
import ca.uhn.hl7v2.model.v24.segment.GT1;
import ca.uhn.hl7v2.model.v24.segment.MSA;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.NK1;
import ca.uhn.hl7v2.model.v24.segment.NTE;
import ca.uhn.hl7v2.model.v24.segment.PID;
import ca.uhn.hl7v2.model.v24.segment.RF1;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RPA_I08
extends AbstractMessage {
    public RPA_I08() {
        this(new DefaultModelClassFactory());
    }

    public RPA_I08(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MSA.class, true, false);
            this.add(RF1.class, false, false);
            this.add(RPA_I08_AUTHORIZATION.class, false, false);
            this.add(RPA_I08_PROVIDER.class, true, true);
            this.add(PID.class, true, false);
            this.add(NK1.class, false, true);
            this.add(GT1.class, false, true);
            this.add(RPA_I08_INSURANCE.class, false, true);
            this.add(ACC.class, false, false);
            this.add(DG1.class, false, true);
            this.add(DRG.class, false, true);
            this.add(AL1.class, false, true);
            this.add(RPA_I08_PROCEDURE.class, true, true);
            this.add(RPA_I08_OBSERVATION.class, false, true);
            this.add(RPA_I08_VISIT.class, false, false);
            this.add(NTE.class, false, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RPA_I08 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.4";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public MSA getMSA() {
        return this.getTyped("MSA", MSA.class);
    }

    public RF1 getRF1() {
        return this.getTyped("RF1", RF1.class);
    }

    public RPA_I08_AUTHORIZATION getAUTHORIZATION() {
        return this.getTyped("AUTHORIZATION", RPA_I08_AUTHORIZATION.class);
    }

    public RPA_I08_PROVIDER getPROVIDER() {
        return this.getTyped("PROVIDER", RPA_I08_PROVIDER.class);
    }

    public RPA_I08_PROVIDER getPROVIDER(int rep) {
        return this.getTyped("PROVIDER", rep, RPA_I08_PROVIDER.class);
    }

    public int getPROVIDERReps() {
        return this.getReps("PROVIDER");
    }

    public List<RPA_I08_PROVIDER> getPROVIDERAll() throws HL7Exception {
        return this.getAllAsList("PROVIDER", RPA_I08_PROVIDER.class);
    }

    public void insertPROVIDER(RPA_I08_PROVIDER structure, int rep) throws HL7Exception {
        super.insertRepetition("PROVIDER", structure, rep);
    }

    public RPA_I08_PROVIDER insertPROVIDER(int rep) throws HL7Exception {
        return (RPA_I08_PROVIDER)super.insertRepetition("PROVIDER", rep);
    }

    public RPA_I08_PROVIDER removePROVIDER(int rep) throws HL7Exception {
        return (RPA_I08_PROVIDER)super.removeRepetition("PROVIDER", rep);
    }

    public PID getPID() {
        return this.getTyped("PID", PID.class);
    }

    public NK1 getNK1() {
        return this.getTyped("NK1", NK1.class);
    }

    public NK1 getNK1(int rep) {
        return this.getTyped("NK1", rep, NK1.class);
    }

    public int getNK1Reps() {
        return this.getReps("NK1");
    }

    public List<NK1> getNK1All() throws HL7Exception {
        return this.getAllAsList("NK1", NK1.class);
    }

    public void insertNK1(NK1 structure, int rep) throws HL7Exception {
        super.insertRepetition("NK1", structure, rep);
    }

    public NK1 insertNK1(int rep) throws HL7Exception {
        return (NK1)super.insertRepetition("NK1", rep);
    }

    public NK1 removeNK1(int rep) throws HL7Exception {
        return (NK1)super.removeRepetition("NK1", rep);
    }

    public GT1 getGT1() {
        return this.getTyped("GT1", GT1.class);
    }

    public GT1 getGT1(int rep) {
        return this.getTyped("GT1", rep, GT1.class);
    }

    public int getGT1Reps() {
        return this.getReps("GT1");
    }

    public List<GT1> getGT1All() throws HL7Exception {
        return this.getAllAsList("GT1", GT1.class);
    }

    public void insertGT1(GT1 structure, int rep) throws HL7Exception {
        super.insertRepetition("GT1", structure, rep);
    }

    public GT1 insertGT1(int rep) throws HL7Exception {
        return (GT1)super.insertRepetition("GT1", rep);
    }

    public GT1 removeGT1(int rep) throws HL7Exception {
        return (GT1)super.removeRepetition("GT1", rep);
    }

    public RPA_I08_INSURANCE getINSURANCE() {
        return this.getTyped("INSURANCE", RPA_I08_INSURANCE.class);
    }

    public RPA_I08_INSURANCE getINSURANCE(int rep) {
        return this.getTyped("INSURANCE", rep, RPA_I08_INSURANCE.class);
    }

    public int getINSURANCEReps() {
        return this.getReps("INSURANCE");
    }

    public List<RPA_I08_INSURANCE> getINSURANCEAll() throws HL7Exception {
        return this.getAllAsList("INSURANCE", RPA_I08_INSURANCE.class);
    }

    public void insertINSURANCE(RPA_I08_INSURANCE structure, int rep) throws HL7Exception {
        super.insertRepetition("INSURANCE", structure, rep);
    }

    public RPA_I08_INSURANCE insertINSURANCE(int rep) throws HL7Exception {
        return (RPA_I08_INSURANCE)super.insertRepetition("INSURANCE", rep);
    }

    public RPA_I08_INSURANCE removeINSURANCE(int rep) throws HL7Exception {
        return (RPA_I08_INSURANCE)super.removeRepetition("INSURANCE", rep);
    }

    public ACC getACC() {
        return this.getTyped("ACC", ACC.class);
    }

    public DG1 getDG1() {
        return this.getTyped("DG1", DG1.class);
    }

    public DG1 getDG1(int rep) {
        return this.getTyped("DG1", rep, DG1.class);
    }

    public int getDG1Reps() {
        return this.getReps("DG1");
    }

    public List<DG1> getDG1All() throws HL7Exception {
        return this.getAllAsList("DG1", DG1.class);
    }

    public void insertDG1(DG1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DG1", structure, rep);
    }

    public DG1 insertDG1(int rep) throws HL7Exception {
        return (DG1)super.insertRepetition("DG1", rep);
    }

    public DG1 removeDG1(int rep) throws HL7Exception {
        return (DG1)super.removeRepetition("DG1", rep);
    }

    public DRG getDRG() {
        return this.getTyped("DRG", DRG.class);
    }

    public DRG getDRG(int rep) {
        return this.getTyped("DRG", rep, DRG.class);
    }

    public int getDRGReps() {
        return this.getReps("DRG");
    }

    public List<DRG> getDRGAll() throws HL7Exception {
        return this.getAllAsList("DRG", DRG.class);
    }

    public void insertDRG(DRG structure, int rep) throws HL7Exception {
        super.insertRepetition("DRG", structure, rep);
    }

    public DRG insertDRG(int rep) throws HL7Exception {
        return (DRG)super.insertRepetition("DRG", rep);
    }

    public DRG removeDRG(int rep) throws HL7Exception {
        return (DRG)super.removeRepetition("DRG", rep);
    }

    public AL1 getAL1() {
        return this.getTyped("AL1", AL1.class);
    }

    public AL1 getAL1(int rep) {
        return this.getTyped("AL1", rep, AL1.class);
    }

    public int getAL1Reps() {
        return this.getReps("AL1");
    }

    public List<AL1> getAL1All() throws HL7Exception {
        return this.getAllAsList("AL1", AL1.class);
    }

    public void insertAL1(AL1 structure, int rep) throws HL7Exception {
        super.insertRepetition("AL1", structure, rep);
    }

    public AL1 insertAL1(int rep) throws HL7Exception {
        return (AL1)super.insertRepetition("AL1", rep);
    }

    public AL1 removeAL1(int rep) throws HL7Exception {
        return (AL1)super.removeRepetition("AL1", rep);
    }

    public RPA_I08_PROCEDURE getPROCEDURE() {
        return this.getTyped("PROCEDURE", RPA_I08_PROCEDURE.class);
    }

    public RPA_I08_PROCEDURE getPROCEDURE(int rep) {
        return this.getTyped("PROCEDURE", rep, RPA_I08_PROCEDURE.class);
    }

    public int getPROCEDUREReps() {
        return this.getReps("PROCEDURE");
    }

    public List<RPA_I08_PROCEDURE> getPROCEDUREAll() throws HL7Exception {
        return this.getAllAsList("PROCEDURE", RPA_I08_PROCEDURE.class);
    }

    public void insertPROCEDURE(RPA_I08_PROCEDURE structure, int rep) throws HL7Exception {
        super.insertRepetition("PROCEDURE", structure, rep);
    }

    public RPA_I08_PROCEDURE insertPROCEDURE(int rep) throws HL7Exception {
        return (RPA_I08_PROCEDURE)super.insertRepetition("PROCEDURE", rep);
    }

    public RPA_I08_PROCEDURE removePROCEDURE(int rep) throws HL7Exception {
        return (RPA_I08_PROCEDURE)super.removeRepetition("PROCEDURE", rep);
    }

    public RPA_I08_OBSERVATION getOBSERVATION() {
        return this.getTyped("OBSERVATION", RPA_I08_OBSERVATION.class);
    }

    public RPA_I08_OBSERVATION getOBSERVATION(int rep) {
        return this.getTyped("OBSERVATION", rep, RPA_I08_OBSERVATION.class);
    }

    public int getOBSERVATIONReps() {
        return this.getReps("OBSERVATION");
    }

    public List<RPA_I08_OBSERVATION> getOBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION", RPA_I08_OBSERVATION.class);
    }

    public void insertOBSERVATION(RPA_I08_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", structure, rep);
    }

    public RPA_I08_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (RPA_I08_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public RPA_I08_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (RPA_I08_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }

    public RPA_I08_VISIT getVISIT() {
        return this.getTyped("VISIT", RPA_I08_VISIT.class);
    }

    public NTE getNTE() {
        return this.getTyped("NTE", NTE.class);
    }

    public NTE getNTE(int rep) {
        return this.getTyped("NTE", rep, NTE.class);
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }
}

