/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v251.group.ORL_O34_ORDER;
import ca.uhn.hl7v2.model.v251.segment.OBX;
import ca.uhn.hl7v2.model.v251.segment.SAC;
import ca.uhn.hl7v2.model.v251.segment.SPM;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORL_O34_SPECIMEN
extends AbstractGroup {
    public ORL_O34_SPECIMEN(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SPM.class, true, false, false);
            this.add(OBX.class, false, true, false);
            this.add(SAC.class, false, true, false);
            this.add(ORL_O34_ORDER.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ORL_O34_SPECIMEN - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public SPM getSPM() {
        SPM retVal = this.getTyped("SPM", SPM.class);
        return retVal;
    }

    public OBX getOBX() {
        OBX retVal = this.getTyped("OBX", OBX.class);
        return retVal;
    }

    public OBX getOBX(int rep) {
        OBX retVal = this.getTyped("OBX", rep, OBX.class);
        return retVal;
    }

    public int getOBXReps() {
        return this.getReps("OBX");
    }

    public List<OBX> getOBXAll() throws HL7Exception {
        return this.getAllAsList("OBX", OBX.class);
    }

    public void insertOBX(OBX structure, int rep) throws HL7Exception {
        super.insertRepetition("OBX", structure, rep);
    }

    public OBX insertOBX(int rep) throws HL7Exception {
        return (OBX)super.insertRepetition("OBX", rep);
    }

    public OBX removeOBX(int rep) throws HL7Exception {
        return (OBX)super.removeRepetition("OBX", rep);
    }

    public SAC getSAC() {
        SAC retVal = this.getTyped("SAC", SAC.class);
        return retVal;
    }

    public SAC getSAC(int rep) {
        SAC retVal = this.getTyped("SAC", rep, SAC.class);
        return retVal;
    }

    public int getSACReps() {
        return this.getReps("SAC");
    }

    public List<SAC> getSACAll() throws HL7Exception {
        return this.getAllAsList("SAC", SAC.class);
    }

    public void insertSAC(SAC structure, int rep) throws HL7Exception {
        super.insertRepetition("SAC", structure, rep);
    }

    public SAC insertSAC(int rep) throws HL7Exception {
        return (SAC)super.insertRepetition("SAC", rep);
    }

    public SAC removeSAC(int rep) throws HL7Exception {
        return (SAC)super.removeRepetition("SAC", rep);
    }

    public ORL_O34_ORDER getORDER() {
        ORL_O34_ORDER retVal = this.getTyped("ORDER", ORL_O34_ORDER.class);
        return retVal;
    }

    public ORL_O34_ORDER getORDER(int rep) {
        ORL_O34_ORDER retVal = this.getTyped("ORDER", rep, ORL_O34_ORDER.class);
        return retVal;
    }

    public int getORDERReps() {
        return this.getReps("ORDER");
    }

    public List<ORL_O34_ORDER> getORDERAll() throws HL7Exception {
        return this.getAllAsList("ORDER", ORL_O34_ORDER.class);
    }

    public void insertORDER(ORL_O34_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", structure, rep);
    }

    public ORL_O34_ORDER insertORDER(int rep) throws HL7Exception {
        return (ORL_O34_ORDER)super.insertRepetition("ORDER", rep);
    }

    public ORL_O34_ORDER removeORDER(int rep) throws HL7Exception {
        return (ORL_O34_ORDER)super.removeRepetition("ORDER", rep);
    }
}

