/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap;

import com.sap.conn.jco.JCoDestination;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.SynchronizationAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DestinationRfcTransactionHandler
extends SynchronizationAdapter {
    public static final String TID_HANDLER_MAP_PROPERTY_KEY = DestinationRfcTransactionHandler.class.getName() + ".tidHandlerMap";
    private static final Logger LOG = LoggerFactory.getLogger(DestinationRfcTransactionHandler.class);
    private JCoDestination destination;
    private Map<String, String> tidMap = new HashMap<String, String>();

    public static String getTID(Exchange exchange, JCoDestination destination) throws Exception {
        DestinationRfcTransactionHandler tidHandler;
        HashMap<String, DestinationRfcTransactionHandler> tidHandlerMap = (HashMap<String, DestinationRfcTransactionHandler>)exchange.getProperty(TID_HANDLER_MAP_PROPERTY_KEY, Map.class);
        if (tidHandlerMap == null) {
            tidHandlerMap = new HashMap<String, DestinationRfcTransactionHandler>();
            exchange.setProperty(TID_HANDLER_MAP_PROPERTY_KEY, tidHandlerMap);
        }
        if ((tidHandler = (DestinationRfcTransactionHandler)((Object)tidHandlerMap.get(destination.getDestinationName()))) != null) {
            return tidHandler.getTID(exchange);
        }
        tidHandler = new DestinationRfcTransactionHandler(destination);
        tidHandlerMap.put(destination.getDestinationName(), tidHandler);
        exchange.getUnitOfWork().addSynchronization((Synchronization)tidHandler);
        return tidHandler.getTID(exchange);
    }

    private DestinationRfcTransactionHandler(JCoDestination destination) {
        if (destination == null) {
            throw new IllegalArgumentException("destination argument can not be null");
        }
        this.destination = destination;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.destination.getDestinationName() == null ? 0 : this.destination.getDestinationName().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DestinationRfcTransactionHandler other = (DestinationRfcTransactionHandler)((Object)obj);
        return !(this.destination == null ? other.destination != null : !this.destination.getDestinationName().equals(other.destination.getDestinationName()));
    }

    protected String getTID(Exchange exchange) throws Exception {
        ProcessorDefinition definition = (ProcessorDefinition)exchange.getProperty("org.fusesource.camel.component.sap.CurrentProcessorDefinition", ProcessorDefinition.class);
        if (definition == null) {
            LOG.warn("Current processor definition not found in exchange: please install org.fusesource.camel.component.sap.CurrentProcessorDefinitionInterceptStrategy into Camel container");
            return this.destination.createTID();
        }
        String tid = this.tidMap.get(definition.getId());
        if (tid == null) {
            tid = this.destination.createTID();
            this.tidMap.put(definition.getId(), tid);
        }
        return tid;
    }

    protected void confirmTids() {
        for (String tid : this.tidMap.values()) {
            try {
                this.destination.confirmTID(tid);
            }
            catch (Exception e) {
                LOG.warn("Failed to confirm transaction id: '" + tid + "': This exception will be ignored", (Throwable)e);
            }
        }
    }

    public void onComplete(Exchange exchange) {
        this.done();
    }

    public void onFailure(Exchange exchange) {
        this.done();
    }

    private void done() {
        this.confirmTids();
        this.tidMap.clear();
    }
}

