/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap;

import com.sap.conn.jco.JCoCustomRepository;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoRepository;
import com.sap.conn.jco.server.JCoServer;
import com.sap.conn.jco.server.JCoServerCallHandlerFactory;
import com.sap.conn.jco.server.JCoServerErrorListener;
import com.sap.conn.jco.server.JCoServerExceptionListener;
import com.sap.conn.jco.server.JCoServerFactory;
import com.sap.conn.jco.server.JCoServerState;
import com.sap.conn.jco.server.JCoServerStateChangedListener;
import com.sap.conn.jco.server.JCoServerTIDHandler;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.fusesource.camel.component.sap.FunctionHandlerFactory;
import org.fusesource.camel.component.sap.ServerErrorAndExceptionListener;
import org.fusesource.camel.component.sap.ServerStateChangedListener;
import org.fusesource.camel.component.sap.ServerTIDHandler;
import org.fusesource.camel.component.sap.model.rfc.RepositoryData;
import org.fusesource.camel.component.sap.util.ComponentRepositoryDataProvider;
import org.fusesource.camel.component.sap.util.RfcUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SapRfcServerComponent
extends UriEndpointComponent {
    private static final Logger LOG = LoggerFactory.getLogger(SapRfcServerComponent.class);
    private static final long JCO_SERVER_STOPPING_WAIT_INTERVAL = 100L;
    protected File tidStoresLocation = new File(".");
    protected Map<String, JCoServer> activeServers = new HashMap<String, JCoServer>();
    protected Map<String, JCoCustomRepository> repositories = new HashMap<String, JCoCustomRepository>();
    protected ServerErrorAndExceptionListener serverErrorAndExceptionListener = new ServerErrorAndExceptionListener();
    protected ServerStateChangedListener serverStateChangedListener = new ServerStateChangedListener();

    public SapRfcServerComponent(Class<? extends Endpoint> endpointClass) {
        super(endpointClass);
    }

    public String getTidStoresLocation() {
        return this.tidStoresLocation.getAbsolutePath();
    }

    public void setTidStoresLocation(String tidStoresLocation) {
        this.tidStoresLocation = new File(tidStoresLocation);
    }

    protected FunctionHandlerFactory getServerHandlerFactory(String serverName) throws Exception {
        JCoServer server = this.getServer(serverName);
        if (server == null) {
            return null;
        }
        return (FunctionHandlerFactory)server.getCallHandlerFactory();
    }

    protected synchronized JCoServer getServer(String serverName) throws Exception {
        JCoServer server = this.activeServers.get(serverName);
        if (server == null) {
            server = JCoServerFactory.getServer((String)serverName);
            if (server.getState() == JCoServerState.STARTED || server.getState() == JCoServerState.ALIVE) {
                throw new Exception("The server connection '" + serverName + "' is already in use");
            }
            if (server.getState() == JCoServerState.STOPPING) {
                while (server.getState() != JCoServerState.STOPPED) {
                    ((Object)((Object)this)).wait(100L);
                }
            }
            server.setCallHandlerFactory((JCoServerCallHandlerFactory)new FunctionHandlerFactory());
            File tidStoreFile = new File(this.tidStoresLocation, serverName);
            server.setTIDHandler((JCoServerTIDHandler)new ServerTIDHandler(tidStoreFile));
            server.addServerExceptionListener((JCoServerExceptionListener)this.serverErrorAndExceptionListener);
            server.addServerErrorListener((JCoServerErrorListener)this.serverErrorAndExceptionListener);
            server.addServerStateChangedListener((JCoServerStateChangedListener)this.serverStateChangedListener);
            String repositoryDestinationName = server.getRepositoryDestination();
            JCoDestination repositoryDestination = null;
            try {
                repositoryDestination = JCoDestinationManager.getDestination((String)repositoryDestinationName);
            }
            catch (Exception e1) {
                LOG.warn("Unable to get repository destination'" + repositoryDestinationName + "' for server '" + serverName + "'", (Throwable)e1);
            }
            JCoCustomRepository repository = this.getRepository(serverName);
            if (repository != null) {
                if (repositoryDestination != null) {
                    try {
                        repository.setDestination(repositoryDestination);
                    }
                    catch (Exception e) {
                        LOG.warn("Unable to set destination on custom repository for server '" + serverName + "'", (Throwable)e);
                    }
                }
                server.setRepository((JCoRepository)repository);
            }
            this.activeServers.put(serverName, server);
            if (this.isStarted()) {
                server.start();
                LOG.debug("Started server " + server.getProgramID());
            }
        }
        return server;
    }

    protected synchronized JCoCustomRepository getRepository(String serverName) {
        JCoCustomRepository repository = this.repositories.get(serverName);
        if (repository == null) {
            RepositoryData repositoryData = ComponentRepositoryDataProvider.INSTANCE.getRepositoryData(serverName);
            repository = RfcUtil.createRepository(serverName, repositoryData);
            this.repositories.put(serverName, repository);
        }
        return repository;
    }

    protected void doStart() throws Exception {
        super.doStart();
        for (JCoServer server : this.activeServers.values()) {
            server.start();
        }
    }

    protected void doStop() throws Exception {
        for (JCoServer server : this.activeServers.values()) {
            server.stop();
            server.removeServerErrorListener((JCoServerErrorListener)this.serverErrorAndExceptionListener);
            server.removeServerExceptionListener((JCoServerExceptionListener)this.serverErrorAndExceptionListener);
            server.removeServerStateChangedListener((JCoServerStateChangedListener)this.serverStateChangedListener);
            server.setTIDHandler(null);
            server.release();
        }
        super.doStop();
    }
}

