/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap.converter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Converter;
import org.eclipse.emf.ecore.EObject;
import org.fusesource.camel.component.sap.model.rfc.Structure;
import org.fusesource.camel.component.sap.model.rfc.impl.StructureImpl;
import org.fusesource.camel.component.sap.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter
public enum StructureConverter {
    INSTANCE;

    private static final Logger LOG;

    @Converter
    public static Structure toStructure(String string) {
        try {
            EObject eObject = Util.unmarshal(string);
            if (StructureImpl.class.isInstance(eObject)) {
                return (StructureImpl)eObject;
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to convert String to Structure", (Throwable)e);
        }
        return null;
    }

    @Converter
    public static Structure toStructure(InputStream in) {
        try {
            EObject eObject = Util.fromInputStream(in);
            if (StructureImpl.class.isInstance(eObject)) {
                return (StructureImpl)eObject;
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to convert InputStream to Structure", (Throwable)e);
        }
        return null;
    }

    @Converter
    public static Structure toStructure(byte[] byteArray) {
        try {
            EObject eObject = Util.unmarshal(new String(byteArray));
            if (StructureImpl.class.isInstance(eObject)) {
                return (StructureImpl)eObject;
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to convert byte array to Structure", (Throwable)e);
        }
        return null;
    }

    @Converter
    public static String toString(StructureImpl structure) {
        try {
            return Util.marshal(structure);
        }
        catch (IOException e) {
            LOG.warn("Failed to convert Structure to String", (Throwable)e);
            return null;
        }
    }

    @Converter
    public static OutputStream toOutputStream(StructureImpl structure) {
        try {
            return Util.toOutputStream(structure);
        }
        catch (IOException e) {
            LOG.warn("Failed to convert Structure to OutputStream", (Throwable)e);
            return null;
        }
    }

    @Converter
    public static InputStream toInputStream(StructureImpl structure) {
        try {
            return Util.toInputStream(structure);
        }
        catch (IOException e) {
            LOG.warn("Failed to convert Structure to InputStream", (Throwable)e);
            return null;
        }
    }

    static {
        LOG = LoggerFactory.getLogger(StructureConverter.class);
    }
}

