/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public final class BundleWideTxData {
    private String value;
    private final List<Pattern> methodList = new ArrayList<Pattern>();
    private final List<Pattern> beanList = new ArrayList<Pattern>();

    public BundleWideTxData(String value, String method, String bean) {
        this.value = value == null || value.length() == 0 ? "Required" : value;
        this.setupPatterns(method, bean);
    }

    private void setupPatterns(String method, String bean) {
        Pattern p;
        int i;
        if (method == null || method.length() == 0) {
            method = "*";
        }
        if (bean == null || bean.length() == 0) {
            bean = "*";
        }
        String[] names = method.split("[, \t]");
        for (i = 0; i < names.length; ++i) {
            p = Pattern.compile(names[i].replaceAll("\\*", ".*"));
            this.methodList.add(p);
        }
        names = bean.split("[, \t]");
        for (i = 0; i < names.length; ++i) {
            p = Pattern.compile(names[i].replaceAll("\\*", ".*"));
            this.beanList.add(p);
        }
    }

    public String getValue() {
        return this.value;
    }

    public List<Pattern> getMethod() {
        return this.methodList;
    }

    public List<Pattern> getBean() {
        return this.beanList;
    }
}

