/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.quiesce.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import org.apache.aries.jpa.container.impl.NLS;
import org.apache.aries.jpa.container.quiesce.impl.DestroyCallback;
import org.apache.aries.jpa.container.quiesce.impl.EntityManagerProxyFactory;
import org.apache.aries.jpa.container.quiesce.impl.NamedCallback;
import org.apache.aries.util.AriesFrameworkUtil;
import org.osgi.framework.ServiceRegistration;

class QuiesceEMFHandler
implements InvocationHandler,
DestroyCallback {
    private final AtomicLong count = new AtomicLong(0L);
    private final EntityManagerFactory delegate;
    private final String name;
    private final AtomicReference<NamedCallback> callback = new AtomicReference();
    private final AtomicReference<ServiceRegistration> reg = new AtomicReference();

    public QuiesceEMFHandler(EntityManagerFactory delegate, String name) {
        this.delegate = delegate;
        this.name = name;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("quiesce".equals(method.getName())) {
            this.quiesce((NamedCallback)args[0], (ServiceRegistration)args[1]);
            return null;
        }
        if ("clearQuiesce".equals(method.getName())) {
            this.clearQuiesce();
            return null;
        }
        Object res = null;
        try {
            res = method.invoke((Object)this.delegate, args);
        }
        catch (IllegalArgumentException e) {
            new PersistenceException(NLS.MESSAGES.getMessage("wrong.JPA.version", new Object[]{method.getName(), this.delegate}), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        if ("createEntityManager".equals(method.getName())) {
            this.count.incrementAndGet();
            return EntityManagerProxyFactory.create((EntityManager)res, this);
        }
        return res;
    }

    public void quiesce(NamedCallback callback, ServiceRegistration reg) {
        this.reg.compareAndSet(null, reg);
        this.callback.compareAndSet(null, callback);
        if (this.count.get() == 0L) {
            AriesFrameworkUtil.safeUnregisterService((ServiceRegistration)this.reg.getAndSet(null));
            this.callback.set(null);
            callback.callback(this.name);
        }
    }

    @Override
    public void callback() {
        NamedCallback c;
        if (this.count.decrementAndGet() == 0L && (c = (NamedCallback)this.callback.getAndSet(null)) != null) {
            AriesFrameworkUtil.safeUnregisterService((ServiceRegistration)this.reg.getAndSet(null));
            c.callback(this.name);
        }
    }

    public void clearQuiesce() {
        this.reg.set(null);
        NamedCallback c = this.callback.getAndSet(null);
        if (c != null) {
            c.callback(this.name);
        }
    }
}

