/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.io;

import java.io.PrintStream;
import java.net.URL;
import org.ops4j.monitors.stream.StreamMonitor;

public class PrintStreamMonitor
implements StreamMonitor {
    private boolean m_first = true;
    private int m_expected;
    private long m_start;
    private PrintStream m_out;

    public PrintStreamMonitor(PrintStream out) {
        this.m_out = out;
    }

    @Override
    public void notifyUpdate(URL resource, int expected, int count) {
        if (this.m_first) {
            this.m_expected = expected;
            this.m_start = System.currentTimeMillis();
            this.m_first = false;
        }
        int completed = count * 100 / expected;
        this.m_out.print(resource.toExternalForm() + " : " + completed + "%    \r");
    }

    @Override
    public void notifyCompletion(URL resource) {
        long now = System.currentTimeMillis();
        long time = now - this.m_start;
        int kBps = (int)((long)this.m_expected / time);
        this.m_out.println(resource.toExternalForm() + " : " + kBps + " kBps.          ");
    }

    @Override
    public void notifyError(URL resource, String message) {
        this.m_out.println(resource.toExternalForm() + " : " + message);
    }
}

