/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.spi.scan;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.ops4j.pax.cdi.spi.BeanBundles;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanScanner {
    private static final String CLASS_EXT = ".class";
    private static final String[] BEAN_DESCRIPTOR_PATHS = new String[]{"META-INF/beans.xml", "WEB-INF/beans.xml"};
    private Logger log = LoggerFactory.getLogger(BeanScanner.class);
    private Bundle bundle;
    private Set<URL> beanDescriptors;
    private Set<String> beanClasses;
    private Set<String> scannedPackages;

    public BeanScanner(Bundle bundle) {
        this.bundle = bundle;
        this.beanDescriptors = new HashSet<URL>();
        this.beanClasses = new TreeSet<String>();
    }

    public Set<String> getBeanClasses() {
        return Collections.unmodifiableSet(this.beanClasses);
    }

    public Set<URL> getBeanDescriptors() {
        return Collections.unmodifiableSet(this.beanDescriptors);
    }

    public void scan() {
        this.scannedPackages = new HashSet<String>();
        this.scanOwnBundle();
        this.scanImportedPackages();
        this.scanWiredBundles("osgi.wiring.bundle", true);
        this.scanWiredBundles("org.ops4j.pax.cdi.extension", false);
        this.logBeanClasses();
    }

    private void logBeanClasses() {
        if (!this.log.isDebugEnabled()) {
            return;
        }
        this.log.debug("candidate bean classes for bundle [{}]:", (Object)this.bundle);
        for (String klass : this.beanClasses) {
            this.log.debug("    {}", (Object)klass);
        }
    }

    private void scanOwnBundle() {
        this.findBeanDescriptors();
        String bundleClassPath = (String)this.bundle.getHeaders().get("Bundle-ClassPath");
        String[] classPathElements = bundleClassPath == null ? new String[]{"/"} : bundleClassPath.split(",");
        for (String cp : classPathElements) {
            String classPath = cp;
            if (classPath.equals(".")) {
                classPath = "/";
            }
            if (classPath.endsWith(".jar") || classPath.endsWith(".zip")) {
                this.scanZip(classPath);
                continue;
            }
            this.scanDirectory(classPath);
        }
    }

    private void findBeanDescriptors() {
        for (String path : BEAN_DESCRIPTOR_PATHS) {
            URL url = this.bundle.getEntry(path);
            if (url == null) continue;
            this.beanDescriptors.add(url);
            return;
        }
    }

    private void scanDirectory(String classPath) {
        Enumeration e = this.bundle.findEntries(classPath, "*.class", true);
        while (e != null && e.hasMoreElements()) {
            URL url = (URL)e.nextElement();
            String klass = this.toClassName(classPath, url);
            this.beanClasses.add(klass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanZip(String zipName) {
        URL zipEntry = this.bundle.getEntry(zipName);
        if (zipEntry == null) {
            return;
        }
        ZipInputStream in = null;
        try {
            ZipEntry entry;
            in = new ZipInputStream(zipEntry.openStream());
            while ((entry = in.getNextEntry()) != null) {
                String name = entry.getName();
                if (!name.endsWith(CLASS_EXT)) continue;
                this.beanClasses.add(this.toClassName("", name));
            }
        }
        catch (IOException exc) {
            this.log.warn("error scanning zip file " + zipName, (Throwable)exc);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private String toClassName(String classPath, URL url) {
        return this.toClassName(classPath, url.getFile());
    }

    private String toClassName(String classPath, String file) {
        String klass = null;
        String[] parts = file.split("!");
        klass = parts.length > 1 ? parts[1] : file;
        if (klass.charAt(0) == '/') {
            klass = klass.substring(1);
        }
        String prefix = classPath;
        if (classPath.length() > 1) {
            if (classPath.charAt(0) == '/') {
                prefix = classPath.substring(1);
            }
            assert (klass.startsWith(prefix));
            int startIndex = prefix.length();
            if (!prefix.endsWith("/")) {
                ++startIndex;
            }
            klass = klass.substring(startIndex);
        }
        klass = klass.replace("/", ".").replace(CLASS_EXT, "");
        this.log.trace("file = {}, class = {}", (Object)file, (Object)klass);
        return klass;
    }

    private void scanImportedPackages() {
        BundleWiring wiring = (BundleWiring)this.bundle.adapt(BundleWiring.class);
        List wires = wiring.getRequiredWires("osgi.wiring.package");
        for (BundleWire wire : wires) {
            this.log.debug("scanning imported package [{}]", (Object)wire);
            this.scanForClasses(wire);
        }
    }

    private void scanForClasses(BundleWire wire) {
        BundleWiring wiring = wire.getProviderWiring();
        Bundle providerBundle = wiring.getBundle();
        if (!BeanBundles.isBeanBundle(providerBundle)) {
            return;
        }
        this.scanExportedPackage(wiring, wire.getCapability());
    }

    private void scanExportedPackage(BundleWiring wiring, BundleCapability capability) {
        String pkg = (String)capability.getAttributes().get("osgi.wiring.package");
        if (this.scannedPackages.contains(pkg)) {
            return;
        }
        this.log.debug("scanning exported package [{}]", (Object)pkg);
        this.scannedPackages.add(pkg);
        Collection entries = wiring.listResources(this.toPath(pkg), "*.class", 2);
        for (String entry : entries) {
            this.beanClasses.add(this.toClassName("", entry));
        }
    }

    private String toPath(String pkg) {
        return pkg.replaceAll("\\.", "/");
    }

    private void scanWiredBundles(String namespace, boolean onlyBeanBundles) {
        BundleWiring wiring = (BundleWiring)this.bundle.adapt(BundleWiring.class);
        List wires = wiring.getRequiredWires(namespace);
        for (BundleWire wire : wires) {
            BundleWiring providerWiring = wire.getProviderWiring();
            Bundle providerBundle = providerWiring.getBundle();
            if (onlyBeanBundles && !BeanBundles.isBeanBundle(providerBundle)) continue;
            this.log.debug("scanning bundle [{}] wired for namespace [{}]", (Object)providerBundle, (Object)namespace);
            List capabilities = providerWiring.getCapabilities("osgi.wiring.package");
            for (BundleCapability pkgCapability : capabilities) {
                this.scanExportedPackage(providerWiring, pkgCapability);
            }
        }
    }
}

