/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.osgi.internal;

import java.util.Map;
import javax.xml.namespace.QName;
import org.osgi.framework.BundleContext;
import org.switchyard.ServiceDomain;
import org.switchyard.bus.camel.CamelExchangeBus;
import org.switchyard.common.camel.SwitchYardCamelContext;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.deploy.ServiceDomainManager;
import org.switchyard.deploy.osgi.internal.OsgiSwitchYardCamelContextImpl;
import org.switchyard.deploy.osgi.internal.SwitchYardExtender;
import org.switchyard.internal.DomainImpl;
import org.switchyard.internal.transform.BaseTransformerRegistry;
import org.switchyard.internal.validate.BaseValidatorRegistry;
import org.switchyard.security.service.ServiceDomainSecurity;
import org.switchyard.spi.ExchangeBus;
import org.switchyard.transform.TransformerRegistry;
import org.switchyard.validate.ValidatorRegistry;

public class OsgiDomainManager
extends ServiceDomainManager {
    private final SwitchYardExtender _extender;

    public OsgiDomainManager(SwitchYardExtender extender) {
        this._extender = extender;
    }

    public ServiceDomain createDomain(BundleContext bundleContext, QName domainName, SwitchYardModel switchyardConfig) {
        BaseTransformerRegistry transformerRegistry = new BaseTransformerRegistry();
        BaseValidatorRegistry validatorRegistry = new BaseValidatorRegistry();
        OsgiSwitchYardCamelContextImpl camelContext = new OsgiSwitchYardCamelContextImpl(bundleContext);
        CamelExchangeBus bus = new CamelExchangeBus((SwitchYardCamelContext)camelContext);
        ServiceDomainSecurity serviceSecurities = this.getServiceDomainSecurity(switchyardConfig);
        DomainImpl domain = new DomainImpl(domainName, this.getRegistry(), (ExchangeBus)bus, (TransformerRegistry)transformerRegistry, (ValidatorRegistry)validatorRegistry, this.getEventManager(), serviceSecurities);
        camelContext.setServiceDomain((ServiceDomain)domain);
        Map properties = this.getDomainProperties(switchyardConfig);
        for (Map.Entry property : properties.entrySet()) {
            domain.setProperty((String)property.getKey(), property.getValue());
        }
        domain.init();
        return domain;
    }
}

