/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletException;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.jsp.JspServletWrapper;
import org.ops4j.pax.web.service.SharedWebContainerContext;
import org.ops4j.pax.web.service.internal.ConfigurationImpl;
import org.ops4j.pax.web.service.internal.DefaultHttpContext;
import org.ops4j.pax.web.service.internal.DefaultSharedWebContainerContext;
import org.ops4j.pax.web.service.internal.StoppableHttpService;
import org.ops4j.pax.web.service.internal.WelcomeFilesFilter;
import org.ops4j.pax.web.service.internal.util.SupportUtils;
import org.ops4j.pax.web.service.spi.Configuration;
import org.ops4j.pax.web.service.spi.ServerController;
import org.ops4j.pax.web.service.spi.ServerEvent;
import org.ops4j.pax.web.service.spi.ServerListener;
import org.ops4j.pax.web.service.spi.ServletEvent;
import org.ops4j.pax.web.service.spi.ServletListener;
import org.ops4j.pax.web.service.spi.model.ContextModel;
import org.ops4j.pax.web.service.spi.model.ErrorPageModel;
import org.ops4j.pax.web.service.spi.model.EventListenerModel;
import org.ops4j.pax.web.service.spi.model.FilterModel;
import org.ops4j.pax.web.service.spi.model.Identity;
import org.ops4j.pax.web.service.spi.model.Model;
import org.ops4j.pax.web.service.spi.model.ResourceModel;
import org.ops4j.pax.web.service.spi.model.SecurityConstraintMappingModel;
import org.ops4j.pax.web.service.spi.model.ServerModel;
import org.ops4j.pax.web.service.spi.model.ServiceModel;
import org.ops4j.pax.web.service.spi.model.ServletModel;
import org.ops4j.pax.web.service.spi.util.ResourceDelegatingBundleClassLoader;
import org.ops4j.pax.web.utils.ClassPathUtil;
import org.ops4j.util.property.DictionaryPropertyResolver;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpServiceStarted
implements StoppableHttpService {
    private static final String PAX_WEB_JSP_SERVLET = "jsp";
    private static final Logger LOG = LoggerFactory.getLogger(HttpServiceStarted.class);
    private static SharedWebContainerContext sharedWebContainerContext = new DefaultSharedWebContainerContext();
    private final Bundle serviceBundle;
    private final ClassLoader bundleClassLoader;
    private final ServerController serverController;
    private final ServerModel serverModel;
    private final ServiceModel serviceModel;
    private final ServerListener serverListener;
    private final ServletListener eventDispatcher;

    HttpServiceStarted(Bundle bundle, ServerController srvController, ServerModel serverModel, ServletListener eventDispatcher) {
        LOG.debug("Creating http service for: " + bundle);
        NullArgumentException.validateNotNull(bundle, "Bundle");
        NullArgumentException.validateNotNull(srvController, "Server controller");
        NullArgumentException.validateNotNull(serverModel, "Service model");
        this.serviceBundle = bundle;
        Set<Bundle> wiredBundles = ClassPathUtil.getBundlesInClassSpace(bundle, new LinkedHashSet<Bundle>());
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        bundles.add(bundle);
        bundles.addAll(wiredBundles);
        this.bundleClassLoader = new ResourceDelegatingBundleClassLoader(bundles);
        this.serverController = srvController;
        this.serverModel = serverModel;
        this.eventDispatcher = eventDispatcher;
        this.serviceModel = new ServiceModel();
        this.serverListener = new ServerListener(){

            @Override
            public void stateChanged(ServerEvent event) {
                LOG.debug("Handling event: [" + (Object)((Object)event) + "]");
                if (event == ServerEvent.STARTED) {
                    for (ServletModel servletModel : HttpServiceStarted.this.serviceModel.getServletModels()) {
                        HttpServiceStarted.this.servletEvent(1, HttpServiceStarted.this.serviceBundle, servletModel);
                        HttpServiceStarted.this.serverController.addServlet(servletModel);
                        HttpServiceStarted.this.servletEvent(2, HttpServiceStarted.this.serviceBundle, servletModel);
                    }
                    for (Model model : HttpServiceStarted.this.serviceModel.getEventListenerModels()) {
                        HttpServiceStarted.this.serverController.addEventListener((EventListenerModel)model);
                    }
                    for (Model model : HttpServiceStarted.this.serviceModel.getFilterModels()) {
                        HttpServiceStarted.this.serverController.addFilter((FilterModel)model);
                    }
                    for (Model model : HttpServiceStarted.this.serviceModel.getErrorPageModels()) {
                        HttpServiceStarted.this.serverController.addErrorPage((ErrorPageModel)model);
                    }
                }
            }
        };
        this.serverController.addListener(this.serverListener);
    }

    @Override
    public void stop() {
        this.serverController.removeListener(this.serverListener);
        for (ServletModel servletModel : this.serviceModel.getServletModels()) {
            this.servletEvent(3, this.serviceBundle, servletModel);
            this.serverModel.removeServletModel(servletModel);
            this.servletEvent(4, this.serviceBundle, servletModel);
        }
        for (Model model : this.serviceModel.getFilterModels()) {
            this.serverModel.removeFilterModel((FilterModel)model);
        }
        for (Identity identity : this.serviceModel.getContextModels()) {
            this.serverController.removeContext(((ContextModel)identity).getHttpContext());
        }
        this.serverModel.deassociateHttpContexts(this.serviceBundle);
    }

    @Override
    public void registerServlet(String alias, Servlet servlet, Dictionary initParams, HttpContext httpContext) throws ServletException, NamespaceException {
        this.registerServlet(alias, servlet, initParams, null, null, httpContext);
    }

    @Override
    public void registerServlet(String alias, Servlet servlet, Dictionary initParams, Integer loadOnStartup, Boolean asyncSupported, HttpContext httpContext) throws ServletException, NamespaceException {
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        LOG.debug("Using context [" + contextModel + "]");
        ServletModel model = new ServletModel(contextModel, servlet, alias, initParams, loadOnStartup, asyncSupported);
        this.registerServlet(model);
    }

    private void servletEvent(int type, Bundle bundle, ServletModel model) {
        this.eventDispatcher.servletEvent(new ServletEvent(type, bundle, model.getAlias(), model.getName(), model.getUrlPatterns(), model.getServlet(), model.getServletClass(), model.getContextModel().getHttpContext()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerServlet(ServletModel model) throws ServletException, NamespaceException {
        this.servletEvent(1, this.serviceBundle, model);
        boolean serverSuccess = false;
        boolean serviceSuccess = false;
        boolean controllerSuccess = false;
        try {
            this.serverModel.addServletModel(model);
            serverSuccess = true;
            this.serviceModel.addServletModel(model);
            serviceSuccess = true;
            this.serverController.addServlet(model);
            controllerSuccess = true;
            ContextModel contextModel = model.getContextModel();
            if (model.getServlet() != null && !this.isWebAppWebContainerContext(contextModel)) {
                try {
                    this.serverController.getContext(contextModel).start();
                }
                catch (Exception e) {
                    LOG.error("Could not start the servlet context for context path [" + contextModel.getContextName() + "]", (Throwable)e);
                }
            }
        }
        finally {
            if (!controllerSuccess) {
                if (serviceSuccess) {
                    this.serviceModel.removeServletModel(model);
                }
                if (serverSuccess) {
                    this.serverModel.removeServletModel(model);
                }
                this.servletEvent(5, this.serviceBundle, model);
            } else {
                this.servletEvent(2, this.serviceBundle, model);
            }
        }
    }

    private boolean isWebAppWebContainerContext(ContextModel contextModel) {
        return contextModel.getHttpContext().getClass().getName().equals("org.ops4j.pax.web.extender.war.internal.WebAppWebContainerContext");
    }

    @Override
    public void registerResources(String alias, String name, HttpContext httpContext) throws NamespaceException {
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        LOG.debug("Registering resource using context [" + contextModel + "]");
        Servlet servlet = this.serverController.createResourceServlet(contextModel, alias, name);
        ResourceModel model = new ResourceModel(contextModel, servlet, alias, name);
        try {
            this.registerServlet(model);
        }
        catch (ServletException e) {
            LOG.error("Caught ServletException: ", (Throwable)e);
            throw new NamespaceException("Resource cant be resolved: ", e);
        }
    }

    @Override
    public void unregister(String alias) {
        ServletModel model = this.serviceModel.getServletModelWithAlias(alias);
        if (model == null) {
            throw new IllegalArgumentException("Alias [" + alias + "] was never registered");
        }
        this.servletEvent(3, this.serviceBundle, model);
        this.serverModel.removeServletModel(model);
        this.serviceModel.removeServletModel(model);
        this.serverController.removeServlet(model);
        this.servletEvent(4, this.serviceBundle, model);
    }

    @Override
    public HttpContext createDefaultHttpContext() {
        return new DefaultHttpContext(this.serviceBundle, "default");
    }

    @Override
    public HttpContext createDefaultHttpContext(String contextID) {
        return new DefaultHttpContext(this.serviceBundle, contextID);
    }

    @Override
    public void registerServlet(Servlet servlet, String[] urlPatterns, Dictionary<String, ?> initParams, HttpContext httpContext) throws ServletException {
        this.registerServlet(servlet, null, urlPatterns, initParams, null, null, httpContext);
    }

    @Override
    public void registerServlet(Servlet servlet, String[] urlPatterns, Dictionary<String, ?> initParams, Integer loadOnStartup, Boolean asyncSupported, HttpContext httpContext) throws ServletException {
        this.registerServlet(servlet, null, urlPatterns, initParams, loadOnStartup, asyncSupported, httpContext);
    }

    @Override
    public void registerServlet(Servlet servlet, String servletName, String[] urlPatterns, Dictionary<String, ?> initParams, HttpContext httpContext) throws ServletException {
        this.registerServlet(servlet, servletName, urlPatterns, initParams, null, null, httpContext);
    }

    @Override
    public void registerServlet(Servlet servlet, String servletName, String[] urlPatterns, Dictionary<String, ?> initParams, Integer loadOnStartup, Boolean asyncSupported, MultipartConfigElement multiPartConfig, HttpContext httpContext) throws ServletException {
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        LOG.debug("Using context [" + contextModel + "]");
        ServletModel model = new ServletModel(contextModel, servlet, servletName, urlPatterns, null, initParams, loadOnStartup, asyncSupported, multiPartConfig);
        try {
            this.registerServlet(model);
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
    }

    @Override
    public void registerServlet(Servlet servlet, String servletName, String[] urlPatterns, Dictionary<String, ?> initParams, Integer loadOnStartup, Boolean asyncSupported, HttpContext httpContext) throws ServletException {
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        LOG.debug("Using context [" + contextModel + "]");
        ServletModel model = new ServletModel(contextModel, servlet, servletName, urlPatterns, null, initParams, loadOnStartup, asyncSupported, null);
        try {
            this.registerServlet(model);
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
    }

    @Override
    public void unregisterServlet(Servlet servlet) {
        ServletModel model = this.serviceModel.removeServlet(servlet);
        if (model != null) {
            this.servletEvent(3, this.serviceBundle, model);
            this.serverModel.removeServletModel(model);
            this.serverController.removeServlet(model);
            this.servletEvent(4, this.serviceBundle, model);
        }
    }

    @Override
    public void registerServlet(Class<? extends Servlet> servletClass, String[] urlPatterns, Dictionary<String, ?> initParams, HttpContext httpContext) throws ServletException {
        this.registerServlet(servletClass, urlPatterns, initParams, null, null, httpContext);
    }

    @Override
    public void registerServlet(Class<? extends Servlet> servletClass, String[] urlPatterns, Dictionary<String, ?> initParams, Integer loadOnStartup, Boolean asyncSupported, HttpContext httpContext) throws ServletException {
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        LOG.debug("Using context [" + contextModel + "]");
        ServletModel model = new ServletModel(contextModel, servletClass, null, urlPatterns, null, initParams, loadOnStartup, asyncSupported, null);
        try {
            this.registerServlet(model);
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
    }

    @Override
    public void registerServlet(Class<? extends Servlet> servletClass, String[] urlPatterns, Dictionary<String, ?> initParams, Integer loadOnStartup, Boolean asyncSupported, MultipartConfigElement multiPartConfig, HttpContext httpContext) throws ServletException {
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        LOG.debug("Using context [" + contextModel + "]");
        ServletModel model = new ServletModel(contextModel, servletClass, null, urlPatterns, null, initParams, loadOnStartup, asyncSupported, multiPartConfig);
        try {
            this.registerServlet(model);
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
    }

    @Override
    public void unregisterServlets(Class<? extends Servlet> servletClass) {
        Set<ServletModel> models = this.serviceModel.removeServletClass(servletClass);
        if (models != null) {
            for (ServletModel model : models) {
                this.servletEvent(3, this.serviceBundle, model);
                this.serverModel.removeServletModel(model);
                this.serverController.removeServlet(model);
                this.servletEvent(4, this.serviceBundle, model);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerEventListener(EventListener listener, HttpContext httpContext) {
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        LOG.debug("Using context [" + contextModel + "]");
        EventListenerModel model = new EventListenerModel(contextModel, listener);
        boolean serviceSuccess = false;
        boolean controllerSuccess = false;
        try {
            this.serviceModel.addEventListenerModel(model);
            serviceSuccess = true;
            this.serverController.addEventListener(model);
            controllerSuccess = true;
        }
        finally {
            if (!controllerSuccess && serviceSuccess) {
                this.serviceModel.removeEventListener(listener);
            }
        }
    }

    @Override
    public void unregisterEventListener(EventListener listener) {
        EventListenerModel model = this.serviceModel.removeEventListener(listener);
        if (model != null) {
            this.serverController.removeEventListener(model);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerFilter(Filter filter, String[] urlPatterns, String[] servletNames, Dictionary<String, ?> initParams, HttpContext httpContext) {
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        LOG.debug("Using context [" + contextModel + "]");
        FilterModel model = new FilterModel(contextModel, filter, urlPatterns, servletNames, initParams);
        boolean serverSuccess = false;
        boolean serviceSuccess = false;
        boolean controllerSuccess = false;
        try {
            this.serverModel.addFilterModel(model);
            serverSuccess = true;
            this.serviceModel.addFilterModel(model);
            serviceSuccess = true;
            this.serverController.addFilter(model);
            controllerSuccess = true;
        }
        finally {
            if (!controllerSuccess) {
                if (serviceSuccess) {
                    this.serviceModel.removeFilter(model.getName());
                }
                if (serverSuccess) {
                    this.serverModel.removeFilterModel(model);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerFilter(Class<? extends Filter> filterClass, String[] urlPatterns, String[] servletNames, Dictionary<String, ?> initParams, HttpContext httpContext) {
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        LOG.debug("Using context [" + contextModel + "]");
        FilterModel model = new FilterModel(contextModel, filterClass, urlPatterns, servletNames, initParams);
        boolean serverSuccess = false;
        boolean serviceSuccess = false;
        boolean controllerSuccess = false;
        try {
            this.serverModel.addFilterModel(model);
            serverSuccess = true;
            this.serviceModel.addFilterModel(model);
            serviceSuccess = true;
            this.serverController.addFilter(model);
            controllerSuccess = true;
        }
        finally {
            if (!controllerSuccess) {
                if (serviceSuccess) {
                    this.serviceModel.removeFilter(model.getName());
                }
                if (serverSuccess) {
                    this.serverModel.removeFilterModel(model);
                }
            }
        }
    }

    @Override
    public void unregisterFilter(Filter filter) {
        FilterModel model = this.serviceModel.removeFilter(filter);
        if (model != null) {
            this.serverModel.removeFilterModel(model);
            this.serverController.removeFilter(model);
        }
    }

    @Override
    public void unregisterFilter(Class<? extends Filter> filterClass) {
        FilterModel model = this.serviceModel.removeFilter(filterClass);
        if (model != null) {
            this.serverModel.removeFilterModel(model);
            this.serverController.removeFilter(model);
        }
    }

    @Override
    public void unregisterFilter(String filterName) {
        FilterModel model = this.serviceModel.removeFilter(filterName);
        if (model != null) {
            this.serverModel.removeFilterModel(model);
            this.serverController.removeFilter(model);
        }
    }

    @Override
    public void setContextParam(Dictionary<String, ?> params, HttpContext httpContext) {
        NullArgumentException.validateNotNull(httpContext, "Http context");
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        Map<String, String> contextParams = contextModel.getContextParams();
        if (!contextParams.equals(params)) {
            if (!this.serviceModel.canBeConfigured(httpContext)) {
                throw new IllegalStateException("Http context already used. Context params can be set/changed only before first usage");
            }
            contextModel.setContextParams(params);
        }
        this.serviceModel.addContextModel(contextModel);
    }

    @Override
    public void setSessionTimeout(Integer minutes, HttpContext httpContext) {
        NullArgumentException.validateNotNull(httpContext, "Http context");
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        Integer sessionTimeout = contextModel.getSessionTimeout();
        if (!(minutes == sessionTimeout || minutes != null && minutes.equals(sessionTimeout))) {
            if (!this.serviceModel.canBeConfigured(httpContext)) {
                throw new IllegalStateException("Http context already used. Session timeout can be set/changed only before first usage");
            }
            contextModel.setSessionTimeout(minutes);
        }
        this.serviceModel.addContextModel(contextModel);
    }

    @Override
    public void registerJsps(String[] urlPatterns, HttpContext httpContext) {
        this.registerJsps(urlPatterns, null, httpContext);
    }

    @Override
    public void registerJsps(String[] urlPatterns, Dictionary<String, ?> initParams, HttpContext httpContext) {
        this.registerJspServlet(urlPatterns, initParams, httpContext, null);
    }

    @Override
    public void registerJspServlet(String[] urlPatterns, HttpContext httpContext, String jspFile) {
        this.registerJspServlet(urlPatterns, null, httpContext, jspFile);
    }

    @Override
    public void registerJspServlet(String[] urlPatterns, Dictionary<String, ?> initParams, HttpContext httpContext, String jspFile) {
        if (!SupportUtils.isJSPAvailable()) {
            throw new UnsupportedOperationException("Jsp support is not enabled. Is org.ops4j.pax.web.jsp bundle installed?");
        }
        JspServletWrapper jspServlet = new JspServletWrapper(this.serviceBundle, jspFile);
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        initParams = this.createInitParams(contextModel, initParams == null ? new Hashtable() : initParams);
        this.serviceModel.addContextModel(contextModel);
        try {
            String[] stringArray;
            String string = this.getJspServletName(jspFile);
            if (urlPatterns == null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "*.jsp";
            } else {
                stringArray = urlPatterns;
            }
            this.registerServlet((Servlet)jspServlet, string, stringArray, initParams, httpContext);
        }
        catch (ServletException ignore) {
            LOG.error("Internal error. Please report.", (Throwable)ignore);
        }
        Map<Servlet, String[]> jspServlets = contextModel.getJspServlets();
        jspServlets.put((Servlet)jspServlet, urlPatterns);
    }

    private String getJspServletName(String jspFile) {
        return jspFile == null ? PAX_WEB_JSP_SERVLET : null;
    }

    private Dictionary<String, ?> createInitParams(ContextModel contextModel, Dictionary<String, ?> initParams) {
        LinkedList<Configuration> configurations = new LinkedList<Configuration>();
        Configuration serverControllerConfiguration = this.serverController.getConfiguration();
        if (initParams != null) {
            DictionaryPropertyResolver propertyResolver = new DictionaryPropertyResolver(initParams);
            Configuration configuration = new ConfigurationImpl(propertyResolver);
            configurations.add(configuration);
        }
        configurations.add(serverControllerConfiguration);
        for (Configuration configuration : configurations) {
            File temporaryDirectory;
            String scratchDir = configuration.getJspScratchDir();
            if (scratchDir == null && (temporaryDirectory = configuration.getTemporaryDirectory()) != null) {
                scratchDir = temporaryDirectory.toString();
            }
            if (configuration.equals(serverControllerConfiguration)) {
                File tempDir = new File(scratchDir, contextModel.getContextName());
                if (!tempDir.exists()) {
                    tempDir.mkdirs();
                }
                scratchDir = tempDir.toString();
            }
            Integer jspCheckInterval = configuration.getJspCheckInterval();
            Boolean jspClassDebugInfo = configuration.getJspClassDebugInfo();
            Boolean jspDevelopment = configuration.getJspDevelopment();
            Boolean jspEnablePooling = configuration.getJspEnablePooling();
            String jspIeClassId = configuration.getJspIeClassId();
            String jspJavaEncoding = configuration.getJspJavaEncoding();
            Boolean jspKeepgenerated = configuration.getJspKeepgenerated();
            String jspLogVerbosityLevel = configuration.getJspLogVerbosityLevel();
            Boolean jspMappedfile = configuration.getJspMappedfile();
            Integer jspTagpoolMaxSize = configuration.getJspTagpoolMaxSize();
            Boolean jspPrecompilation = configuration.getJspPrecompilation();
            HashMap<String, Object> params = new HashMap<String, Object>(12);
            params.put("checkInterval", jspCheckInterval);
            params.put("classdebuginfo", jspClassDebugInfo);
            params.put("development", jspDevelopment);
            params.put("enablePooling", jspEnablePooling);
            params.put("ieClassId", jspIeClassId);
            params.put("javaEncoding", jspJavaEncoding);
            params.put("keepgenerated", jspKeepgenerated);
            params.put("logVerbosityLevel", jspLogVerbosityLevel);
            params.put("mappedfile", jspMappedfile);
            params.put("scratchdir", scratchDir);
            params.put("tagpoolMaxSize", jspTagpoolMaxSize);
            params.put("usePrecompiled", jspPrecompilation);
            params.keySet().removeAll(Collections.list(initParams.keys()));
            for (Map.Entry entry : params.entrySet()) {
                Object param = entry.getValue();
                if (param == null) continue;
                String initParam = (String)entry.getKey();
                ((Hashtable)initParams).put(initParam, param.toString());
            }
        }
        LOG.debug("JSP scratchdir: " + initParams.get("scratchdir"));
        return initParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterJsps(HttpContext httpContext) {
        if (!SupportUtils.isJSPAvailable()) {
            throw new UnsupportedOperationException("Jsp support is not enabled. Is org.ops4j.pax.web.jsp bundle installed?");
        }
        NullArgumentException.validateNotNull(httpContext, "Http context");
        ContextModel contextModel = this.serviceModel.getContextModel(httpContext);
        if (contextModel == null) {
            throw new IllegalArgumentException("Jsp support is not enabled for http context [" + httpContext + "]");
        }
        Iterator<Servlet> jspServlets = contextModel.getJspServlets().keySet().iterator();
        while (jspServlets.hasNext()) {
            Servlet jspServlet = jspServlets.next();
            try {
                this.unregisterServlet(jspServlet);
            }
            finally {
                jspServlets.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterJsps(String[] urlPatterns, HttpContext httpContext) {
        if (!SupportUtils.isJSPAvailable()) {
            throw new UnsupportedOperationException("Jsp support is not enabled. Is org.ops4j.pax.web.jsp bundle installed?");
        }
        NullArgumentException.validateNotNull(httpContext, "Http context");
        ContextModel contextModel = this.serviceModel.getContextModel(httpContext);
        if (contextModel == null) {
            throw new IllegalArgumentException("Jsp support is not enabled for http context [" + httpContext + "]");
        }
        Iterator<Map.Entry<Servlet, String[]>> jspServlets = contextModel.getJspServlets().entrySet().iterator();
        while (jspServlets.hasNext()) {
            Map.Entry<Servlet, String[]> entry = jspServlets.next();
            Object[] candidateUrlPatterns = entry.getValue();
            if (!Arrays.equals(urlPatterns, candidateUrlPatterns)) continue;
            Servlet jspServlet = entry.getKey();
            try {
                this.unregisterServlet(jspServlet);
            }
            finally {
                jspServlets.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerErrorPage(String error, String location, HttpContext httpContext) {
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        LOG.debug("Using context [{}]", (Object)contextModel);
        ErrorPageModel model = new ErrorPageModel(contextModel, error, location);
        boolean serviceSuccess = false;
        boolean controllerSuccess = false;
        try {
            this.serviceModel.addErrorPageModel(model);
            serviceSuccess = true;
            this.serverController.addErrorPage(model);
            controllerSuccess = true;
        }
        finally {
            if (!controllerSuccess && serviceSuccess) {
                this.serviceModel.removeErrorPage(error, contextModel);
            }
        }
    }

    @Override
    public void unregisterErrorPage(String error, HttpContext httpContext) {
        NullArgumentException.validateNotNull(httpContext, "Http context");
        ErrorPageModel model = this.serviceModel.removeErrorPage(error, this.serviceModel.getContextModel(httpContext));
        if (model != null) {
            this.serverController.removeErrorPage(model);
        }
    }

    @Override
    public void registerWelcomeFiles(String[] welcomeFiles, boolean redirect, HttpContext httpContext) {
        ContextModel contextModel = this.serviceModel.getContextModel(httpContext);
        if (contextModel != null && contextModel.getWelcomeFilesFilter() != null) {
            throw new IllegalStateException("Welcome files already registered for this context");
        }
        WelcomeFilesFilter welcomeFilesFilter = new WelcomeFilesFilter(welcomeFiles, redirect);
        try {
            this.registerFilter(welcomeFilesFilter, new String[]{"/*"}, null, null, httpContext);
            if (contextModel == null) {
                contextModel = this.serviceModel.getContextModel(httpContext);
            }
            contextModel.setWelcomeFilesFilter(welcomeFilesFilter);
        }
        catch (Exception ignore) {
            LOG.error("Internal error. Please report.", (Throwable)ignore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterWelcomeFiles(HttpContext httpContext) {
        NullArgumentException.validateNotNull(httpContext, "Http context");
        ContextModel contextModel = this.serviceModel.getContextModel(httpContext);
        if (contextModel == null || contextModel.getWelcomeFilesFilter() == null) {
            throw new IllegalArgumentException("Welcome files are not registered for http context [" + httpContext + "]");
        }
        try {
            this.unregisterFilter(contextModel.getWelcomeFilesFilter());
        }
        finally {
            contextModel.setWelcomeFilesFilter(null);
        }
    }

    @Override
    public void registerLoginConfig(String authMethod, String realmName, String formLoginPage, String formErrorPage, HttpContext httpContext) {
        NullArgumentException.validateNotNull(httpContext, "Http context");
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        String contextModelAuthMethod = contextModel.getAuthMethod();
        String contextModelRealmName = contextModel.getRealmName();
        String contextModelFormLoginPage = contextModel.getFormLoginPage();
        String contextModelFormErrorPage = contextModel.getFormErrorPage();
        if (!Arrays.asList(contextModelAuthMethod, contextModelRealmName, contextModelFormLoginPage, contextModelFormErrorPage).equals(Arrays.asList(authMethod, realmName, formLoginPage, formErrorPage))) {
            if (!this.serviceModel.canBeConfigured(httpContext)) {
                throw new IllegalStateException("Http context already used. Session timeout can be set/changed only before first usage");
            }
            contextModel.setAuthMethod(authMethod);
            contextModel.setRealmName(realmName);
            contextModel.setFormLoginPage(formLoginPage);
            contextModel.setFormErrorPage(formErrorPage);
        }
        this.serviceModel.addContextModel(contextModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterLoginConfig(HttpContext httpContext) {
        NullArgumentException.validateNotNull(httpContext, "Http context");
        ContextModel contextModel = this.serviceModel.getContextModel(httpContext);
        if (contextModel == null || contextModel.getAuthMethod() == null || contextModel.getRealmName() == null) {
            throw new IllegalArgumentException("Security Realm and authorization method are not registered for http context [" + httpContext + "]");
        }
    }

    @Override
    public void registerConstraintMapping(String constraintName, String url, String mapping, String dataConstraint, boolean authentication, List<String> roles, HttpContext httpContext) {
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        LOG.debug("Using context [" + contextModel + "]");
        SecurityConstraintMappingModel secConstraintMapModel = new SecurityConstraintMappingModel(contextModel, constraintName, mapping, url, dataConstraint, authentication, roles);
        this.serviceModel.addSecurityConstraintMappingModel(secConstraintMapModel);
        this.serverController.addSecurityConstraintMapping(secConstraintMapModel);
    }

    @Override
    public void unregisterConstraintMapping(HttpContext httpContext) {
        NullArgumentException.validateNotNull(httpContext, "Http context");
    }

    @Override
    public void registerServletContainerInitializer(ServletContainerInitializer servletContainerInitializer, Class<?>[] classes, HttpContext httpContext) {
        Map<ServletContainerInitializer, Set<Class<?>>> containerInitializers;
        Set<Class<?>> containerInitializersClasses;
        NullArgumentException.validateNotNull(httpContext, "Http context");
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        LOG.debug("Using context [" + contextModel + "]");
        HashSet clazzes = new HashSet();
        if (classes != null) {
            Collections.addAll(clazzes, classes);
        }
        Set<Class<?>> set = containerInitializersClasses = (containerInitializers = contextModel.getContainerInitializers()) == null ? null : containerInitializers.get(servletContainerInitializer);
        if (!clazzes.equals(containerInitializersClasses)) {
            if (!this.serviceModel.canBeConfigured(httpContext)) {
                throw new IllegalStateException("Http context already used. ServletContainerInitializer can be set/changed only before first usage");
            }
            contextModel.addContainerInitializer(servletContainerInitializer, clazzes);
        }
        this.serviceModel.addContextModel(contextModel);
    }

    @Override
    public void registerJettyWebXml(URL jettyWebXmlURL, HttpContext httpContext) {
        NullArgumentException.validateNotNull(httpContext, "Http context");
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        LOG.debug("Using context [" + contextModel + "]");
        URL contextModelJettyWebXmlURL = contextModel.getJettyWebXmlURL();
        if (!(contextModelJettyWebXmlURL == jettyWebXmlURL || contextModelJettyWebXmlURL != null && contextModelJettyWebXmlURL.equals(jettyWebXmlURL))) {
            if (!this.serviceModel.canBeConfigured(httpContext)) {
                throw new IllegalStateException("Http context already used. ServletContainerInitializer can be set/changed only before first usage");
            }
            contextModel.setJettyWebXmlUrl(jettyWebXmlURL);
        }
        this.serviceModel.addContextModel(contextModel);
    }

    private ContextModel getOrCreateContext(HttpContext httpContext) {
        HttpContext context = httpContext;
        if (context == null) {
            context = this.createDefaultHttpContext();
        }
        this.serverModel.associateHttpContext(context, this.serviceBundle, httpContext instanceof SharedWebContainerContext);
        ContextModel contextModel = this.serviceModel.getContextModel(context);
        if (contextModel == null) {
            contextModel = new ContextModel(context, this.serviceBundle, this.bundleClassLoader);
            contextModel.setConnectors(this.serverController.getConfiguration().getConnectors());
            contextModel.setVirtualHosts(this.serverController.getConfiguration().getVirtualHosts());
        }
        return contextModel;
    }

    @Override
    public SharedWebContainerContext getDefaultSharedHttpContext() {
        return sharedWebContainerContext;
    }

    @Override
    public void unregisterServletContainerInitializer(HttpContext httpContext) {
    }

    @Override
    public void begin(HttpContext httpContext) {
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        LOG.debug("Using context [" + contextModel + "]");
        try {
            this.serverController.getContext(contextModel).stop();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            LOG.warn("Exception starting HttpContext registration");
        }
    }

    @Override
    public void end(HttpContext httpContext) {
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        LOG.debug("Using context [" + contextModel + "]");
        try {
            this.serverController.getContext(contextModel).start();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            LOG.warn("Exception finalizing HttpContext registration");
        }
    }

    @Override
    public void setVirtualHosts(List<String> virtualHosts, HttpContext httpContext) {
        NullArgumentException.validateNotNull(httpContext, "Http context");
        if (!this.serviceModel.canBeConfigured(httpContext)) {
            throw new IllegalStateException("Http context already used. ServletContainerInitializer can be set only before first usage");
        }
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        LOG.debug("Using context [" + contextModel + "]");
        List<String> realVirtualHosts = virtualHosts;
        if (realVirtualHosts.size() == 0) {
            realVirtualHosts = this.serverController.getConfiguration().getVirtualHosts();
        }
        contextModel.setVirtualHosts(realVirtualHosts);
        this.serviceModel.addContextModel(contextModel);
    }

    @Override
    public void setConnectors(List<String> connectors, HttpContext httpContext) {
        NullArgumentException.validateNotNull(httpContext, "Http context");
        if (!this.serviceModel.canBeConfigured(httpContext)) {
            throw new IllegalStateException("Http context already used. ServletContainerInitializer can be set only before first usage");
        }
        ContextModel contextModel = this.getOrCreateContext(httpContext);
        LOG.debug("Using context [" + contextModel + "]");
        List<String> realConnectors = connectors;
        if (realConnectors.size() == 0) {
            realConnectors = this.serverController.getConfiguration().getConnectors();
        }
        contextModel.setConnectors(realConnectors);
        this.serviceModel.addContextModel(contextModel);
    }
}

