/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.war.internal;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.ops4j.pax.swissbox.bnd.BndUtils;
import org.ops4j.pax.swissbox.bnd.OverwriteMode;
import org.ops4j.pax.url.war.internal.Configuration;
import org.ops4j.pax.url.war.internal.WarConnection;

public class WebBundleConnection
extends WarConnection {
    public WebBundleConnection(URL url, Configuration config) throws MalformedURLException {
        super(url, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected InputStream createBundle(InputStream inputStream, Properties instructions, String warUri) throws IOException {
        String ctxtPath;
        BufferedInputStream bis = new BufferedInputStream(inputStream, 65536);
        bis.mark(65536);
        boolean isBundle = false;
        try {
            JarInputStream jis = new JarInputStream(bis){

                @Override
                public void close() throws IOException {
                }
            };
            Manifest man = jis.getManifest();
            if (man.getMainAttributes().getValue("Bundle-SymbolicName") != null) {
                isBundle = true;
            }
            jis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (bis.markSupported()) {
                try {
                    bis.reset();
                }
                catch (IOException e) {}
            }
        }
        if (isBundle) {
            Properties originalInstructions = BndUtils.parseInstructions((String)this.getURL().getQuery());
            if (originalInstructions.size() > 1 || originalInstructions.size() == 1 && !originalInstructions.containsKey("Web-ContextPath")) {
                throw new MalformedURLException("The webbundle URL handler can not be used with bundles");
            }
            instructions.remove("Import-Package");
            instructions.remove("Export-Package");
        }
        if (instructions.get("Web-ContextPath") != null && !(ctxtPath = (String)instructions.get("Web-ContextPath")).startsWith("/")) {
            ctxtPath = "/" + ctxtPath;
            instructions.setProperty("Web-ContextPath", ctxtPath);
        }
        return super.createBundle(bis, instructions, warUri, OverwriteMode.MERGE);
    }
}

