/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceReference;
import org.overlord.commons.services.AbstractServiceRegistry;
import org.overlord.commons.services.Messages;
import org.overlord.commons.services.ServiceListener;

public class OSGiServiceRegistry
extends AbstractServiceRegistry {
    private static final Logger LOG = Logger.getLogger(OSGiServiceRegistry.class.getName());
    private Map<ServiceListener<?>, ServiceListenerAdapter<?>> _listeners = new HashMap();
    private Map<Class<?>, List<Object>> _services = new HashMap();
    private Map<Class<?>, ServiceListener<?>> _serviceListeners = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> void init(final Class<T> serviceInterface, Object service) {
        boolean createListener = false;
        boolean initService = false;
        Map<Class<?>, List<Object>> map = this._services;
        synchronized (map) {
            List<Object> services = this._services.get(serviceInterface);
            if (services == null) {
                createListener = true;
                services = new ArrayList<Object>();
                this._services.put(serviceInterface, services);
            }
            if (!services.contains(service)) {
                initService = true;
                services.add(service);
            }
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Initialize interface=" + serviceInterface + " service=" + service + " initService=" + initService + " createListener=" + createListener);
        }
        if (initService) {
            super.init(service);
        }
        if (createListener) {
            ServiceListener sl = new ServiceListener<T>(){

                @Override
                public void registered(T service) {
                }

                @Override
                public void unregistered(T service) {
                    OSGiServiceRegistry.this.close(serviceInterface, service);
                }
            };
            this.addServiceListener(serviceInterface, sl);
            Map<Class<?>, ServiceListener<?>> map2 = this._serviceListeners;
            synchronized (map2) {
                this._serviceListeners.put(serviceInterface, sl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(Class<?> serviceInterface, Object service) {
        boolean removeListener = false;
        boolean closeService = false;
        Map<Class<?>, List<Object>> map = this._services;
        synchronized (map) {
            List<Object> services = this._services.get(serviceInterface);
            if (services != null) {
                closeService = services.remove(service);
                if (services.size() == 0) {
                    removeListener = true;
                    this._services.remove(serviceInterface);
                }
            }
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Close interface=" + serviceInterface + " service=" + service + " closeService=" + closeService + " removeListener=" + removeListener);
        }
        if (closeService) {
            super.close(service);
        }
        if (removeListener) {
            ServiceListener<?> l = null;
            Map<Class<?>, ServiceListener<?>> map2 = this._serviceListeners;
            synchronized (map2) {
                l = this._serviceListeners.remove(serviceInterface);
            }
            if (l != null) {
                this.removeServiceListener(l);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <T> T getSingleService(Class<T> serviceInterface) throws IllegalStateException {
        Object service = null;
        try {
            Bundle bundle = FrameworkUtil.getBundle(serviceInterface);
            if (bundle == null) return (T)service;
            BundleContext context = bundle.getBundleContext();
            if (context != null) {
                ServiceReference[] serviceReferences = context.getServiceReferences(serviceInterface.getName(), null);
                if (serviceReferences == null) return (T)service;
                if (serviceReferences.length != 1) throw new IllegalStateException(Messages.getString("OSGiServiceRegistry.MultipleImplsRegistered") + serviceInterface);
                service = context.getService(serviceReferences[0]);
                this.init(serviceInterface, service);
                return (T)service;
            } else {
                LOG.warning(Messages.format("OSGiServiceRegistry.MissingBundleContext", serviceInterface));
            }
            return (T)service;
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> Set<T> getServices(Class<T> serviceInterface) {
        HashSet<Object> services = new HashSet<Object>();
        try {
            Bundle bundle = FrameworkUtil.getBundle(serviceInterface);
            if (bundle != null) {
                ServiceReference[] serviceReferences;
                BundleContext context;
                if (bundle.getState() == 4) {
                    bundle.start();
                }
                if ((context = bundle.getBundleContext()) != null && (serviceReferences = context.getServiceReferences(serviceInterface.getName(), null)) != null) {
                    for (ServiceReference serviceReference : serviceReferences) {
                        Object service = context.getService(serviceReference);
                        this.init(serviceInterface, service);
                        services.add(service);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void addServiceListener(Class<T> serviceInterface, ServiceListener<T> listener) {
        ServiceListenerAdapter<T> adapter = new ServiceListenerAdapter<T>(serviceInterface, listener, this);
        Map<ServiceListener<?>, ServiceListenerAdapter<?>> map = this._listeners;
        synchronized (map) {
            this._listeners.put(listener, adapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void removeServiceListener(ServiceListener<T> listener) {
        ServiceListenerAdapter<?> adapter = null;
        Map<ServiceListener<?>, ServiceListenerAdapter<?>> map = this._listeners;
        synchronized (map) {
            adapter = this._listeners.remove(listener);
        }
        if (adapter != null) {
            adapter.close();
        }
    }

    public static class ServiceListenerAdapter<T> {
        private Class<T> _serviceInterface;
        private ServiceListener<T> _serviceListener;
        private OSGiServiceRegistry _serviceRegistry;
        private org.osgi.framework.ServiceListener _osgiListener = null;

        public ServiceListenerAdapter(Class<T> serviceInterface, ServiceListener<T> listener, OSGiServiceRegistry reg) {
            this._serviceInterface = serviceInterface;
            this._serviceListener = listener;
            this._serviceRegistry = reg;
            this.init();
        }

        protected void init() {
            Bundle bundle = FrameworkUtil.getBundle(this._serviceInterface);
            if (bundle != null) {
                final BundleContext context = bundle.getBundleContext();
                this._osgiListener = new org.osgi.framework.ServiceListener(){

                    public void serviceChanged(ServiceEvent ev) {
                        ServiceReference sr = ev.getServiceReference();
                        Object service = context.getService(sr);
                        switch (ev.getType()) {
                            case 1: {
                                ServiceListenerAdapter.this._serviceRegistry.init(ServiceListenerAdapter.this._serviceInterface, service);
                                ServiceListenerAdapter.this._serviceListener.registered(service);
                                break;
                            }
                            case 4: {
                                ServiceListenerAdapter.this._serviceListener.unregistered(service);
                                ServiceListenerAdapter.this._serviceRegistry.close(ServiceListenerAdapter.this._serviceInterface, service);
                                break;
                            }
                        }
                    }
                };
                String filter = "(objectclass=" + this._serviceInterface.getName() + ")";
                try {
                    context.addServiceListener(this._osgiListener, filter);
                }
                catch (InvalidSyntaxException e) {
                    LOG.log(Level.SEVERE, Messages.format("OSGiServiceRegistry.FailedToAddListener", this._serviceInterface.getName()));
                }
                try {
                    ServiceReference[] srefs = context.getServiceReferences(this._serviceInterface.getName(), null);
                    if (srefs != null) {
                        for (int i = 0; i < srefs.length; ++i) {
                            Object service = context.getService(srefs[i]);
                            this._serviceRegistry.init(service);
                            this._serviceListener.registered(service);
                        }
                    }
                }
                catch (InvalidSyntaxException e) {
                    LOG.log(Level.SEVERE, Messages.format("OSGiServiceRegistry.FailedToAddServiceReferences", this._serviceInterface.getName()));
                }
            }
        }

        public void close() {
        }
    }
}

